/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.effects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wicketstuff.wiquery.core.effects.EffectSpeed;
import org.wicketstuff.wiquery.core.javascript.ChainableStatement;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsUtils;

public abstract class Effect
implements ChainableStatement,
Serializable {
    private static final long serialVersionUID = 6498661896790365888L;
    private List<CharSequence> parameters;
    private JsScope callback;

    public Effect(CharSequence ... parameters) {
        this.parameters = new ArrayList<CharSequence>(Arrays.asList(parameters));
    }

    public Effect(EffectSpeed effectSpeed, CharSequence ... parameters) {
        this(parameters);
        this.parameters.add(0, JsUtils.quotes(effectSpeed.getJavaScriptStatement()));
    }

    public Effect(EffectSpeed effectSpeed, JsScope callback, CharSequence ... parameters) {
        this(parameters);
        this.parameters.add(0, JsUtils.quotes(effectSpeed.getJavaScriptStatement()));
        this.callback = callback;
    }

    @Override
    public CharSequence[] statementArgs() {
        ArrayList<CharSequence> ret = new ArrayList<CharSequence>(this.parameters);
        if (this.effectCallback() != null) {
            ret.add(this.effectCallback().render());
        }
        return ret.toArray(new CharSequence[ret.size()]);
    }

    public JsScope effectCallback() {
        return this.callback;
    }

    public void setCallback(JsScope callback) {
        this.callback = callback;
    }
}

