/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.wicketstuff.wiquery.core.javascript.ChainableStatement;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.helper.AttributesHelper;
import org.wicketstuff.wiquery.core.javascript.helper.CssHelper;
import org.wicketstuff.wiquery.core.javascript.helper.ManipulatingHelper;
import org.wicketstuff.wiquery.core.options.Options;

public class JsStatement
implements Serializable {
    private static final long serialVersionUID = 3254345351404601200L;
    private StringBuilder statement = new StringBuilder();

    public JsStatement $() {
        this.statement.append('$');
        return this;
    }

    public JsStatement $(Component context) {
        StringBuilder dollarSelector = new StringBuilder();
        if (context == null) {
            dollarSelector.append("");
        } else {
            dollarSelector.append('#').append(context.getMarkupId());
        }
        this.statement.append("$('");
        this.statement.append((CharSequence)dollarSelector);
        this.statement.append("')");
        return this;
    }

    public JsStatement $(Component context, String selector) {
        StringBuilder dollarSelector = new StringBuilder();
        if (context == null) {
            dollarSelector.append(selector);
        } else {
            dollarSelector.append('#').append(context.getMarkupId()).append(' ').append(selector);
        }
        this.statement.append("$('");
        this.statement.append((CharSequence)dollarSelector);
        this.statement.append("')");
        return this;
    }

    public JsStatement addClass(String className) {
        this.chain(AttributesHelper.addClass(className));
        return this;
    }

    public JsStatement after(CharSequence html) {
        this.chain(ManipulatingHelper.after(html));
        return this;
    }

    public JsStatement append(CharSequence charSequence) {
        this.statement.append(charSequence);
        return this;
    }

    public JsStatement attr(String key, JsScope computedValue) {
        this.chain(AttributesHelper.attr(key, computedValue));
        return this;
    }

    public JsStatement attr(String key, String value) {
        this.chain(AttributesHelper.attr(key, value));
        return this;
    }

    public JsStatement before(CharSequence html) {
        this.chain(ManipulatingHelper.before(html));
        return this;
    }

    public JsStatement chain(ChainableStatement chainableStatement) {
        this.chain(chainableStatement.chainLabel(), chainableStatement.statementArgs());
        return this;
    }

    public JsStatement chain(CharSequence statementLabel, CharSequence ... statementArgs) {
        this.statement.append('.').append(statementLabel).append('(');
        if (statementArgs.length > 0) {
            this.statement.append(statementArgs[0]);
            for (int i = 1; i < statementArgs.length; ++i) {
                CharSequence charSequence = statementArgs[i];
                this.statement.append(", ").append(charSequence);
            }
        }
        this.statement.append(')');
        return this;
    }

    public JsStatement css(Options options) {
        this.chain(CssHelper.css(options));
        return this;
    }

    public JsStatement css(String name, String value) {
        this.chain(CssHelper.css(name, value));
        return this;
    }

    public JsStatement document() {
        this.statement.append("$(document)");
        return this;
    }

    public JsStatement each(JsScope scope) {
        return this.chain("each", scope.render());
    }

    public StringBuilder getStatement() {
        return this.statement;
    }

    public JsStatement html(CharSequence htmlContents) {
        this.chain(AttributesHelper.html(htmlContents));
        return this;
    }

    public JsStatement insertAfter(String expression) {
        this.chain(ManipulatingHelper.insertAfter(expression));
        return this;
    }

    public JsStatement insertBefore(String expression) {
        this.chain(ManipulatingHelper.insertBefore(expression));
        return this;
    }

    public JsStatement ready(JsScope scope) {
        return this.chain("ready", scope.render());
    }

    public JsStatement removeAttr(String key) {
        this.chain(AttributesHelper.removeAttr(key));
        return this;
    }

    public JsStatement removeClass(String className) {
        this.chain(AttributesHelper.removeClass(className));
        return this;
    }

    public CharSequence render() {
        return this.render(true);
    }

    public CharSequence render(boolean semicolon) {
        char last;
        String trimRendering;
        String render = this.statement.toString();
        if (semicolon && (trimRendering = render.trim()).length() > 0 && (last = trimRendering.charAt(trimRendering.length() - 1)) != '}' && last != ';') {
            render = render + ";";
        }
        return render;
    }

    public JsStatement self() {
        this.statement.append("$(this)");
        return this;
    }

    public JsStatement toggleClass(String className) {
        this.chain(AttributesHelper.toggleClass(className));
        return this;
    }
}

