/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.events.EventLabel;
import org.wicketstuff.wiquery.core.events.MouseEvent;
import org.wicketstuff.wiquery.core.javascript.JsUtils;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class JsUtilsTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(JsUtilsTestCase.class);

    @Test
    public void testArray() {
        String expectedJavascript = "['a', 'b', 'c']";
        String generatedJavascript = JsUtils.array((CharSequence[])new CharSequence[]{"'a'", "'b'", "'c'"}).toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testDoubleQuotes() {
        String expectedJavascript = "\"a\"";
        String generatedJavascript = JsUtils.doubleQuotes((CharSequence)"a");
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        expectedJavascript = "\"\\\"Hello\\\"\"";
        generatedJavascript = JsUtils.doubleQuotes((CharSequence)"\"Hello\"", (boolean)true);
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testEscapeDoubleQuote() {
        String expectedJavascript = "\\\"Hello\\\"";
        String generatedJavascript = JsUtils.escapeDoubleQuote((CharSequence)"\"Hello\"");
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testEscapeQuote() {
        String expectedJavascript = "l\\'oiseau";
        String generatedJavascript = JsUtils.escapeQuote((CharSequence)"l'oiseau");
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testImplode() {
        String expectedJavascript = "'click dblclick'";
        String generatedJavascript = JsUtils.implode((EventLabel[])new EventLabel[]{MouseEvent.CLICK, MouseEvent.DBLCLICK});
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testQuotes() {
        String expectedJavascript = "'a'";
        String generatedJavascript = JsUtils.quotes((CharSequence)"a");
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        expectedJavascript = "'l\\'oiseau'";
        generatedJavascript = JsUtils.quotes((CharSequence)"l'oiseau", (boolean)true);
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testString() {
        String expectedJavascript = "5";
        String generatedJavascript = JsUtils.string((int)5);
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

