/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.events.EventLabel;
import org.wicketstuff.wiquery.core.events.MouseEvent;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.EventsHelper;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class EventsHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(EventsHelperTestCase.class);
    private JsStatement jsStatement;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.jsStatement = new JsStatement().$(null, "div");
    }

    @Test
    public void testBind() {
        this.assertAndLog("$('div').bind('click', function() {\n\talert('click done');\n});", this.jsStatement.chain(EventsHelper.bind((EventLabel)MouseEvent.CLICK, (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render());
    }

    @Test
    public void testBlur() {
        this.assertAndLog("$('div').blur();", this.jsStatement.chain(EventsHelper.blur()).render());
    }

    @Test
    public void testBlurJsScope() {
        this.assertAndLog("$('div').blur(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.blur((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testChange() {
        this.assertAndLog("$('div').change();", this.jsStatement.chain(EventsHelper.change()).render());
    }

    @Test
    public void testChangeJsScope() {
        this.assertAndLog("$('div').change(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.change((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testClick() {
        this.assertAndLog("$('div').click();", this.jsStatement.chain(EventsHelper.click()).render());
    }

    @Test
    public void testClickJsScope() {
        this.assertAndLog("$('div').click(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.click((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testDblclick() {
        this.assertAndLog("$('div').dblclick();", this.jsStatement.chain(EventsHelper.dblclick()).render());
    }

    @Test
    public void testDblclickJsScope() {
        this.assertAndLog("$('div').dblclick(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.dblclick((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testDie() {
        this.assertAndLog("$('div').die('click', function() {\n\talert('click done');\n});", this.jsStatement.chain(EventsHelper.die((EventLabel)MouseEvent.CLICK, (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render());
    }

    @Test
    public void testError() {
        this.assertAndLog("$('div').error();", this.jsStatement.chain(EventsHelper.error()).render());
    }

    @Test
    public void testErrorJsScope() {
        this.assertAndLog("$('div').error(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.error((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testFocus() {
        this.assertAndLog("$('div').focus();", this.jsStatement.chain(EventsHelper.focus()).render());
    }

    @Test
    public void testFocusJsScope() {
        this.assertAndLog("$('div').focus(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.focus((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testHover() {
        this.assertAndLog("$('div').hover(function() {\n\talert('over');\n}, function() {\n\talert('out');\n});", this.jsStatement.chain(EventsHelper.hover((JsScope)JsScope.quickScope((CharSequence)"alert('over');"), (JsScope)JsScope.quickScope((CharSequence)"alert('out');"))).render());
    }

    @Test
    public void testKeydown() {
        this.assertAndLog("$('div').keydown();", this.jsStatement.chain(EventsHelper.keydown()).render());
    }

    @Test
    public void testKeydownJsScope() {
        this.assertAndLog("$('div').keydown(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.keydown((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testKeypress() {
        this.assertAndLog("$('div').keypress();", this.jsStatement.chain(EventsHelper.keypress()).render());
    }

    @Test
    public void testKeypressJsScope() {
        this.assertAndLog("$('div').keypress(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.keypress((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testKeyup() {
        this.assertAndLog("$('div').keyup();", this.jsStatement.chain(EventsHelper.keyup()).render());
    }

    @Test
    public void testKeyupJsScope() {
        this.assertAndLog("$('div').keyup(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.keyup((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testLive() {
        this.assertAndLog("$('div').live('click', function() {\n\talert('click done');\n});", this.jsStatement.chain(EventsHelper.live((EventLabel)MouseEvent.CLICK, (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render());
    }

    @Test
    public void testLoad() {
        this.assertAndLog("$('div').load(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.load((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMousedown() {
        this.assertAndLog("$('div').mousedown(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mousedown((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMouseenter() {
        this.assertAndLog("$('div').mouseenter(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mouseenter((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMouseleave() {
        this.assertAndLog("$('div').mouseleave(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mouseleave((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMousemove() {
        this.assertAndLog("$('div').mousemove(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mousemove((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMouseout() {
        this.assertAndLog("$('div').mouseout(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mouseout((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMouseover() {
        this.assertAndLog("$('div').mouseover(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mouseover((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testMouseup() {
        this.assertAndLog("$('div').mouseup(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.mouseup((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testOne() {
        this.assertAndLog("$('div').one('click', function() {\n\talert('click done');\n});", this.jsStatement.chain(EventsHelper.one((EventLabel)MouseEvent.CLICK, (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render());
    }

    @Test
    public void testReady() {
        this.assertAndLog("$('div').ready(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.ready((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testScroll() {
        this.assertAndLog("$('div').scroll(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.scroll((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testSelect() {
        this.assertAndLog("$('div').select();", this.jsStatement.chain(EventsHelper.select()).render());
    }

    @Test
    public void testSelectJsScope() {
        this.assertAndLog("$('div').select(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.select((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testSubmit() {
        this.assertAndLog("$('div').submit();", this.jsStatement.chain(EventsHelper.submit()).render());
    }

    @Test
    public void testSubmitJsScope() {
        this.assertAndLog("$('div').submit(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.submit((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Test
    public void testToggleJsScopeJsScope() {
        this.assertAndLog("$('div').toggle(function() {\n\talert('a');\n}, function() {\n\talert('b');\n});", this.jsStatement.chain(EventsHelper.toggle((JsScope)JsScope.quickScope((CharSequence)"alert('a');"), (JsScope)JsScope.quickScope((CharSequence)"alert('b');"))).render());
    }

    @Test
    public void testToggleJsScopeJsScopeJsScopeArray() {
        this.assertAndLog("$('div').toggle(function() {\n\talert('a');\n}, function() {\n\talert('b');\n}, function() {\n\talert('c');\n});", this.jsStatement.chain(EventsHelper.toggle((JsScope)JsScope.quickScope((CharSequence)"alert('a');"), (JsScope)JsScope.quickScope((CharSequence)"alert('b');"), (JsScope[])new JsScope[]{JsScope.quickScope((CharSequence)"alert('c');")})).render());
    }

    @Test
    public void testTriggerEventLabel() {
        this.assertAndLog("$('div').trigger('click');", this.jsStatement.chain(EventsHelper.trigger((EventLabel)MouseEvent.CLICK)).render());
    }

    @Test
    public void testTriggerEventLabelCharSequenceArray() {
        this.assertAndLog("$('div').trigger('click', ['a']);", this.jsStatement.chain(EventsHelper.trigger((EventLabel)MouseEvent.CLICK, (CharSequence[])new CharSequence[]{"'a'"})).render());
    }

    @Test
    public void testTriggerHandlerEventLabel() {
        this.assertAndLog("$('div').triggerHandler('click');", this.jsStatement.chain(EventsHelper.triggerHandler((EventLabel)MouseEvent.CLICK)).render());
    }

    @Test
    public void testTriggerHandlerEventLabelCharSequenceArray() {
        this.assertAndLog("$('div').triggerHandler('click', ['a']);", this.jsStatement.chain(EventsHelper.triggerHandler((EventLabel)MouseEvent.CLICK, (CharSequence[])new CharSequence[]{"'a'"})).render());
    }

    @Test
    public void testUnbind() {
        this.assertAndLog("$('div').unbind('click', function() {\n\talert('click done');\n});", this.jsStatement.chain(EventsHelper.unbind((EventLabel)MouseEvent.CLICK, (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render());
    }

    @Test
    public void testUnload() {
        this.assertAndLog("$('div').unload(function() {\n\talert('done');\n});", this.jsStatement.chain(EventsHelper.unload((JsScope)JsScope.quickScope((CharSequence)"alert('done');"))).render());
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

