/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.helper.DateHelper;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class DateHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(DateHelperTestCase.class);

    @Test
    public void testGetJSDate() {
        String expectedJavascript = "new Date()";
        String generatedJavascript = DateHelper.getJSDate().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testGetJSDateWithCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(2009, 11, 7);
        String expectedJavascript = "new Date(2009,11,7,0,0,0,0)";
        String generatedJavascript = DateHelper.getJSDate((Calendar)calendar).toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testGetJSDateWithDate() {
        GregorianCalendar calendar = new GregorianCalendar(2009, 11, 11);
        String expectedJavascript = "new Date(2009,11,11,0,0,0,0)";
        String generatedJavascript = DateHelper.getJSDate((Date)calendar.getTime()).toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

