/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.TraversingHelper;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class TraversingHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(TraversingHelperTestCase.class);

    @Test
    public void testAdd() {
        String expectedJavascript = "$('div').add('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.add((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testChildren() {
        String expectedJavascript = "$('div').children('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.children((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testContents() {
        String expectedJavascript = "$('div').contents('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.contents((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testEq() {
        String expectedJavascript = "$('div').eq(1);";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.eq((int)1)).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testFilter() {
        String expectedJavascript = "$('div').filter('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.filter((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testFind() {
        String expectedJavascript = "$('div').find('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.find((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testNext() {
        String expectedJavascript = "$('div').next('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.next((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testNextAll() {
        String expectedJavascript = "$('div').nextAll('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.nextAll((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testNot() {
        String expectedJavascript = "$('div').not('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.not((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testParent() {
        String expectedJavascript = "$('div').parent('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.parent((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testParents() {
        String expectedJavascript = "$('div').parents('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.parents((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testPrev() {
        String expectedJavascript = "$('div').prev('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.prev((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testPrevAll() {
        String expectedJavascript = "$('div').prevAll('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.prevAll((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testSiblings() {
        String expectedJavascript = "$('div').siblings('span');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.siblings((String)"span")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testSlice() {
        String expectedJavascript = "$('div').slice(1);";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.slice((int)1)).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testSlice2() {
        String expectedJavascript = "$('div').slice(1, 3);";
        String generatedJavascript = new JsStatement().$(null, "div").chain(TraversingHelper.slice((int)1, (int)3)).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

