/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.options;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.options.ArrayItemOptions;
import org.wicketstuff.wiquery.core.options.ICollectionItemOptions;
import org.wicketstuff.wiquery.core.options.IComplexOption;
import org.wicketstuff.wiquery.core.options.IntegerItemOptions;
import org.wicketstuff.wiquery.core.options.Options;
import org.wicketstuff.wiquery.core.options.OptionsTestPage;
import org.wicketstuff.wiquery.core.options.OptionsTestPanel;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class OptionsTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(OptionsTestCase.class);

    @Test
    public void testGetBoolean() {
        Options options = new Options();
        options.put("keyBoolean", true);
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.getBoolean("keyBoolean"));
    }

    @Test
    public void testGetIComplexOption() {
        DefaultComplexOptionImpl impl = new DefaultComplexOptionImpl();
        Options options = new Options();
        options.put("keyComplexOption", (IComplexOption)impl);
        Assert.assertFalse((boolean)options.isEmpty());
        IComplexOption complexOption = options.getComplexOption("keyComplexOption");
        Assert.assertNotNull((Object)complexOption);
        Assert.assertEquals((Object)impl, (Object)complexOption);
    }

    @Test
    public void testOptionsDetachment() {
        Options options = new Options();
        WithMemoryModel iRemeberFloat = new WithMemoryModel(new Model((Serializable)Float.valueOf(1.0f)));
        options.putFloat("keyFloat", iRemeberFloat);
        Assert.assertFalse((boolean)options.isEmpty());
        WithMemoryModel iRemeberShort = new WithMemoryModel(new Model((Serializable)Short.valueOf((short)1)));
        options.putShort("keyShort", iRemeberShort);
        WithMemoryModel iRemeberInteger = new WithMemoryModel(new Model((Serializable)Integer.valueOf(1)));
        options.putInteger("keyInteger", iRemeberInteger);
        WithMemoryModel iRemeberDouble = new WithMemoryModel(new Model((Serializable)Double.valueOf(1.0)));
        options.putDouble("keyDouble", iRemeberDouble);
        WithMemoryModel iRemeberString = new WithMemoryModel(new Model((Serializable)((Object)"String")));
        options.putString("keyString", iRemeberString);
        WithMemoryModel iRemeberLiteral = new WithMemoryModel(new Model((Serializable)((Object)"String")));
        options.putString("keyLiteral", iRemeberLiteral);
        WithMemoryModel iRemeberBoolean = new WithMemoryModel(new Model((Serializable)Boolean.valueOf(true)));
        options.putBoolean("keyBoolean", iRemeberBoolean);
        Assert.assertFalse((boolean)options.isEmpty());
        options.detach();
        Assert.assertTrue((boolean)iRemeberShort.isDetached());
        Assert.assertTrue((boolean)iRemeberFloat.isDetached());
        Assert.assertTrue((boolean)iRemeberInteger.isDetached());
        Assert.assertTrue((boolean)iRemeberDouble.isDetached());
        Assert.assertTrue((boolean)iRemeberString.isDetached());
        Assert.assertTrue((boolean)iRemeberLiteral.isDetached());
        Assert.assertTrue((boolean)iRemeberBoolean.isDetached());
    }

    @Test
    public void testOptionsWrappedModels() {
        OptionsTestPanel panel = new OptionsTestPanel("panel");
        Options options = panel.getOptions();
        options.putString("test", (IModel)new ResourceModel("key"));
        options.putString("test1", (IModel)new Model((Serializable)((Object)"Test1")));
        options.put("test2", false);
        OptionsTestPage page = new OptionsTestPage(panel);
        page = (OptionsTestPage)this.tester.startPage((Page)page);
        String expectedResult = "Test";
        String result = options.get("test");
        log.info("result=" + result);
        log.info("expectedResult=" + expectedResult);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        Assert.assertEquals((Object)"Test1", (Object)options.get("test1"));
        Assert.assertEquals((Object)false, (Object)options.getBoolean("test2"));
        this.tester.assertNoErrorMessage();
    }

    @Test
    public void testGetFloat() {
        Options options = new Options();
        options.put("keyFloat", 1.0f);
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)options.getFloat("keyFloat"));
    }

    @Test
    public void testGetICollectionItemOptions() {
        ArrayItemOptions array = new ArrayItemOptions();
        IntegerItemOptions o1 = new IntegerItemOptions(5);
        IntegerItemOptions o2 = new IntegerItemOptions(23);
        array.add((Object)o1);
        array.add((Object)o2);
        Options options = new Options();
        options.put("keyOptions", (ICollectionItemOptions)array);
        Assert.assertFalse((boolean)options.isEmpty());
        ICollectionItemOptions temp = options.getCollectionItemOptions("keyOptions");
        Assert.assertNotNull((Object)temp);
        Assert.assertEquals((long)2L, (long)temp.values().length);
    }

    @Test
    public void testGetInt() {
        Options options = new Options();
        options.put("keyInt", 1);
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertEquals((long)1L, (long)options.getInt("keyInt").intValue());
    }

    @Test
    public void testGetJavaScriptOptions() {
        ArrayItemOptions array = new ArrayItemOptions();
        IntegerItemOptions o1 = new IntegerItemOptions(5);
        IntegerItemOptions o2 = new IntegerItemOptions(23);
        array.add((Object)o1);
        array.add((Object)o2);
        DefaultComplexOptionImpl impl = new DefaultComplexOptionImpl();
        JsScope jsScope = JsScope.quickScope((CharSequence)"alert('test');");
        Options options = new Options();
        options.put("keyBoolean", true);
        options.putBoolean("keyBooleanModel", (IModel)new Model((Serializable)Boolean.valueOf(false)));
        options.put("keyFloat", 1.0f);
        options.putFloat("keyFloatModel", (IModel)new Model((Serializable)Float.valueOf(2.0f)));
        options.put("keyInt", 1);
        options.putInteger("keyIntModel", (IModel)new Model((Serializable)Integer.valueOf(2)));
        options.putLiteral("keyLiteral", "literal");
        options.putLiteral("keyLiteralModel", (IModel)new Model((Serializable)((Object)"literal1")));
        options.put("keyString", "string");
        options.putString("keyStringModel", (IModel)new Model((Serializable)((Object)"string1")));
        options.put("keyOptions", (ICollectionItemOptions)array);
        options.put("keyScope", jsScope);
        options.put("keyComplexOption", (IComplexOption)impl);
        String generatedJavascript = options.getJavaScriptOptions().toString();
        log.info(generatedJavascript);
        Assert.assertTrue((boolean)generatedJavascript.startsWith("{"));
        Assert.assertTrue((boolean)generatedJavascript.endsWith("}"));
        generatedJavascript = generatedJavascript.substring(1, generatedJavascript.length() - 1);
        List<String> opts = Arrays.asList(generatedJavascript.split(", "));
        Assert.assertEquals((long)opts.size(), (long)13L);
        Assert.assertTrue((boolean)opts.contains("keyString: string"));
        Assert.assertTrue((boolean)opts.contains("keyStringModel: string1"));
        Assert.assertTrue((boolean)opts.contains("keyBoolean: true"));
        Assert.assertTrue((boolean)opts.contains("keyBooleanModel: false"));
        Assert.assertTrue((boolean)opts.contains("keyInt: 1"));
        Assert.assertTrue((boolean)opts.contains("keyIntModel: 2"));
        Assert.assertTrue((boolean)opts.contains("keyComplexOption: alert('complex option');"));
        Assert.assertTrue((boolean)opts.contains("keyFloat: 1.0"));
        Assert.assertTrue((boolean)opts.contains("keyFloatModel: 2.0"));
        Assert.assertTrue((boolean)opts.contains("keyOptions: [5,23]"));
        Assert.assertTrue((boolean)opts.contains("keyLiteral: 'literal'"));
        Assert.assertTrue((boolean)opts.contains("keyLiteralModel: 'literal1'"));
        Assert.assertTrue((boolean)opts.contains("keyScope: function() {\n\talert('test');\n}"));
    }

    @Test
    public void testGetLiteral() {
        Options options = new Options();
        options.putLiteral("keyLiteral", "literal");
        options.putLiteral("keyLiteralModel", (IModel)new Model((Serializable)((Object)"literal1")));
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertEquals((Object)"literal", (Object)options.getLiteral("keyLiteral"));
        Assert.assertEquals((Object)"literal1", (Object)options.getLiteral("keyLiteralModel"));
    }

    @Test
    public void testGetString() {
        Options options = new Options();
        options.put("keyString", "string");
        options.putString("keyStringModel", (IModel)new Model((Serializable)((Object)"string")));
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertEquals((Object)"string", (Object)options.get("keyString"));
        Assert.assertEquals((Object)"string", (Object)options.get("keyStringModel"));
    }

    @Test
    public void testPutBoolean() {
        Options options = new Options();
        options.put("keyBoolean", true);
        options.putBoolean("keyBooleanModel", (IModel)new Model((Serializable)Boolean.valueOf(true)));
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyBoolean"));
        Assert.assertTrue((boolean)options.containsKey((Object)"keyBooleanModel"));
    }

    @Test
    public void testPutComplexOption() {
        Options options = new Options();
        options.put("keyComplexOption", (IComplexOption)new DefaultComplexOptionImpl());
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyComplexOption"));
    }

    @Test
    public void testPutFloat() {
        Options options = new Options();
        options.put("keyFloat", 1.0f);
        options.putFloat("keyFloatModel", (IModel)new Model((Serializable)Float.valueOf(1.0f)));
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyFloat"));
        Assert.assertTrue((boolean)options.containsKey((Object)"keyFloatModel"));
    }

    @Test
    public void testPutICollectionItemOptions() {
        Options options = new Options();
        options.put("keyOptions", (ICollectionItemOptions)new ArrayItemOptions());
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyOptions"));
    }

    @Test
    public void testPutInt() {
        Options options = new Options();
        options.put("keyInt", 1);
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyInt"));
    }

    @Test
    public void testPutLiterral() {
        Options options = new Options();
        options.putLiteral("keyLiteral", "literal");
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyLiteral"));
    }

    @Test
    public void testPutString() {
        Options options = new Options();
        options.put("keyString", "string");
        Assert.assertFalse((boolean)options.isEmpty());
        Assert.assertTrue((boolean)options.containsKey((Object)"keyString"));
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    private class DefaultComplexOptionImpl
    implements IComplexOption {
        private static final long serialVersionUID = 1L;

        private DefaultComplexOptionImpl() {
        }

        public CharSequence getJavascriptOption() {
            return "alert('complex option');";
        }
    }

    public static class WithMemoryModel<T extends Serializable>
    extends Model<T> {
        private static final long serialVersionUID = 1L;
        private boolean detached = false;
        private IModel<T> model;

        public WithMemoryModel(IModel<T> model) {
            this.model = model;
        }

        public void detach() {
            super.detach();
            this.model.detach();
            this.detached = true;
        }

        public boolean isDetached() {
            return this.detached;
        }
    }
}

