/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.tester;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.util.tester.WicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.wicketstuff.wiquery.tester.CollectingVisitor;
import org.wicketstuff.wiquery.tester.matchers.ComponentMatcher;
import org.wicketstuff.wiquery.tester.matchers.ComponentTypeMatcher;

public class WiQueryTester
extends WicketTester {
    public <X extends Component> X first(MarkupContainer root, ComponentMatcher matcher) {
        CollectingVisitor visitor = new CollectingVisitor(matcher, true);
        root.visitChildren(visitor);
        return (X)(visitor.matchedComponents.isEmpty() ? null : (Component)visitor.matchedComponents.get(0));
    }

    public <X extends Component> List<X> all(MarkupContainer root, ComponentMatcher matcher) {
        CollectingVisitor visitor = new CollectingVisitor(matcher);
        root.visitChildren(visitor);
        return visitor.matchedComponents;
    }

    public <X extends Component> X first(MarkupContainer root, Class<X> componentType) {
        CollectingVisitor visitor = new CollectingVisitor(new ComponentTypeMatcher(componentType), true);
        root.visitChildren(visitor);
        return (X)((Component)visitor.matchedComponents.get(0));
    }

    public <X extends Component> List<X> all(MarkupContainer root, Class<X> componentType) {
        ComponentTypeMatcher matcher = new ComponentTypeMatcher(componentType);
        CollectingVisitor visitor = new CollectingVisitor(matcher);
        root.visitChildren(componentType, visitor);
        return visitor.matchedComponents;
    }

    public void setValue(FormComponent<?> input, String value) {
        this.getLastRequest().setParameter(input.getInputName(), value);
    }

    public RepeatingView getRepeatingView(String path) {
        Page renderedPage = this.getLastRenderedPage();
        this.assertComponent(path, RepeatingView.class);
        RepeatingView rv = (RepeatingView)renderedPage.get(path);
        return rv;
    }

    public ListView<?> getListView(String path) {
        Page renderedPage = this.getLastRenderedPage();
        this.assertComponent(path, ListView.class);
        ListView rv = (ListView)renderedPage.get(path);
        return rv;
    }

    public List<IHeaderContributor> getHeaderContributors() {
        Page renderedPage = this.getLastRenderedPage();
        final ArrayList<IHeaderContributor> contributors = new ArrayList<IHeaderContributor>();
        renderedPage.visitChildren((IVisitor)new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                for (Behavior behavior : component.getBehaviors()) {
                    if (!(behavior instanceof IHeaderContributor)) continue;
                    contributors.add((IHeaderContributor)behavior);
                }
            }
        });
        return contributors;
    }
}

