/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsScopeEvent;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class JsScopeEventTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(JsScopeEventTestCase.class);

    @Test
    public void testQuickScope() {
        String expectedJavascript = "function(event) {\n\talert('test');\n}";
        JsScopeEvent quickScope = JsScopeEvent.quickScope((CharSequence)"alert('test');");
        String generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testQuickScopeJsStatement() {
        String expectedJavascript = "function(event) {\n\talert('test');\n}";
        JsScopeEvent quickScope = JsScopeEvent.quickScope((JsStatement)new JsStatement().append((CharSequence)"alert('test')"));
        String generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

