/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsScopeContext;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class JsScopeTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(JsScopeTestCase.class);

    @Test
    public void testQuickScope() {
        String expectedJavascript = "function() {\n\talert('test');\n}";
        JsScope quickScope = JsScope.quickScope((CharSequence)"alert('test');");
        String generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testQuickScopeJsStatement() {
        String expectedJavascript = "function() {\n\talert('test');\n}";
        JsScope quickScope = JsScope.quickScope((JsStatement)new JsStatement().append((CharSequence)"alert('test')"));
        String generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        generatedJavascript = quickScope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testJsScopeUiEventSyntax() {
        String expectedJavascript = "function(param1, param2, param3) {\n\talert('test');\n}";
        JsScope scope = new JsScope(new String[]{"param1", "param2", "param3"}){
            private static final long serialVersionUID = 1L;

            protected void execute(JsScopeContext scopeContext) {
                scopeContext.append((CharSequence)"alert('test');");
            }
        };
        String generatedJavascript = scope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        generatedJavascript = scope.render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

