/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.commons.DivTestPanel;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.CssHelper;
import org.wicketstuff.wiquery.core.options.Options;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class JsStatementTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(JsStatementTestCase.class);
    private JsStatement jsStatement;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.jsStatement = new JsStatement();
    }

    @Test
    public void test$() {
        this.assertAndLog("$;", this.jsStatement.$().render());
    }

    @Test
    public void test$Component() {
        WebMarkupContainer component = new WebMarkupContainer("anId");
        DivTestPanel panel = new DivTestPanel("panelId");
        component.setMarkupId("anId");
        panel.add(new Component[]{component});
        this.tester.startComponentInPage((Component)panel);
        this.assertAndLog("$('#anId');", this.jsStatement.$((Component)component).render());
    }

    @Test
    public void test$ComponentString() {
        this.assertAndLog("$('span');", this.jsStatement.$(null, "span").render());
        this.jsStatement = new JsStatement();
        WebMarkupContainer component = new WebMarkupContainer("anId");
        DivTestPanel panel = new DivTestPanel("panelId");
        component.setMarkupId("anId");
        panel.add(new Component[]{component});
        this.tester.startComponentInPage((Component)panel);
        this.assertAndLog("$('#anId span');", this.jsStatement.$((Component)component, "span").render());
    }

    @Test
    public void testAddClass() {
        this.assertAndLog("$('span').addClass('myClass');", this.jsStatement.$(null, "span").addClass("myClass").render());
    }

    @Test
    public void testAfter() {
        this.assertAndLog("$('span').after('<div>some text</div>');", this.jsStatement.$(null, "span").after((CharSequence)"<div>some text</div>").render());
    }

    @Test
    public void testAppend() {
        this.assertAndLog("$('div').click();", this.jsStatement.append((CharSequence)"$('div').click()").render());
    }

    @Test
    public void testAttrStringJsScope() {
        this.assertAndLog("$('span').attr('click', function() {\n\talert('click done');\n});", this.jsStatement.$(null, "span").attr("click", JsScope.quickScope((CharSequence)"alert('click done');")).render());
    }

    @Test
    public void testAttrStringString() {
        this.assertAndLog("$('span').attr('title', 'a title');", this.jsStatement.$(null, "span").attr("title", "a title").render());
    }

    @Test
    public void testBefore() {
        this.assertAndLog("$('span').before('<div>some text</div>');", this.jsStatement.$(null, "span").before((CharSequence)"<div>some text</div>").render());
    }

    @Test
    public void testChainChainableStatement() {
        this.assertAndLog("$('span').css('font-weight', 'bold');", this.jsStatement.$(null, "span").chain(CssHelper.css((String)"font-weight", (String)"bold")).render());
    }

    @Test
    public void testChainCharSequenceCharSequenceArray() {
        this.assertAndLog("$('span').a(b, c);", this.jsStatement.$(null, "span").chain((CharSequence)"a", new CharSequence[]{"b", "c"}).render());
    }

    @Test
    public void testCssOptions() {
        Options options = new Options();
        options.putLiteral("font-weight", "bold");
        this.assertAndLog("$('span').css({font-weight: 'bold'});", this.jsStatement.$(null, "span").css(options).render());
    }

    @Test
    public void testCssStringString() {
        this.assertAndLog("$('span').css('font-weight', 'bold');", this.jsStatement.$(null, "span").css("font-weight", "bold").render());
    }

    @Test
    public void testDocument() {
        this.assertAndLog("$(document);", this.jsStatement.document().render());
    }

    @Test
    public void testEach() {
        this.assertAndLog("$('span').each(function() {\n\talert('done');\n});", this.jsStatement.$(null, "span").each(JsScope.quickScope((CharSequence)"alert('done');")).render());
    }

    @Test
    public void testHtml() {
        this.assertAndLog("$('span').html('some text');", this.jsStatement.$(null, "span").html((CharSequence)"some text").render());
    }

    @Test
    public void testInsertAfter() {
        this.assertAndLog("$('span').insertAfter('<div>some text</div>');", this.jsStatement.$(null, "span").insertAfter("<div>some text</div>").render());
    }

    @Test
    public void testInsertBefore() {
        this.assertAndLog("$('span').insertBefore('<div>some text</div>');", this.jsStatement.$(null, "span").insertBefore("<div>some text</div>").render());
    }

    @Test
    public void testReady() {
        this.assertAndLog("$('span').ready(function() {\n\talert('done');\n});", this.jsStatement.$(null, "span").ready(JsScope.quickScope((CharSequence)"alert('done');")).render());
    }

    @Test
    public void testRemoveAttr() {
        this.assertAndLog("$('span').removeAttr('title');", this.jsStatement.$(null, "span").removeAttr("title").render());
    }

    @Test
    public void testRemoveClass() {
        this.assertAndLog("$('span').removeClass('myClass');", this.jsStatement.$(null, "span").removeClass("myClass").render());
    }

    @Test
    public void testRender() {
        this.assertAndLog("$;", this.jsStatement.$().render());
    }

    @Test
    public void testRenderBoolean() {
        this.assertAndLog("$;", this.jsStatement.$().render(true));
        this.jsStatement = new JsStatement();
        this.assertAndLog("$", this.jsStatement.$().render(false));
    }

    @Test
    public void testSelf() {
        this.assertAndLog("$(this);", this.jsStatement.self().render());
    }

    @Test
    public void testToggleClass() {
        this.assertAndLog("$('span').toggleClass('myClass');", this.jsStatement.$(null, "span").toggleClass("myClass").render());
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

