/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.CssHelper;
import org.wicketstuff.wiquery.core.options.Options;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class CssHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(CssHelperTestCase.class);

    @Test
    public void testCss() {
        String expectedJavascript = "$('div').css('font-weight', 'bold');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(CssHelper.css((String)"font-weight", (String)"bold")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testCssOptions() {
        String expectedJavascript = "$('div').css({font-weight: 'bold'});";
        Options options = new Options();
        options.putLiteral("font-weight", "bold");
        String generatedJavascript = new JsStatement().$(null, "div").chain(CssHelper.css((Options)options)).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

