/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.ManipulatingHelper;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class ManipulatingHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(ManipulatingHelperTestCase.class);

    @Test
    public void testAfter() {
        String expectedJavascript = "$('div').after('<div>a<div>');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(ManipulatingHelper.after((CharSequence)"<div>a<div>")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testBefore() {
        String expectedJavascript = "$('div').before('<div>a<div>');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(ManipulatingHelper.before((CharSequence)"<div>a<div>")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testInsertAfter() {
        String expectedJavascript = "$('div').insertAfter('<div>a<div>');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(ManipulatingHelper.insertAfter((String)"<div>a<div>")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testInsertBefore() {
        String expectedJavascript = "$('div').insertBefore('<div>a<div>');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(ManipulatingHelper.insertBefore((String)"<div>a<div>")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

