/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.options;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.options.ArrayItemOptions;
import org.wicketstuff.wiquery.core.options.IntegerItemOptions;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class ArrayItemOptionsTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(ArrayItemOptionsTestCase.class);

    @Test
    public void testGetJavascriptItemOptions() {
        ArrayItemOptions options = new ArrayItemOptions();
        IntegerItemOptions o1 = new IntegerItemOptions(5);
        IntegerItemOptions o2 = new IntegerItemOptions(43);
        String expectedJavascript = "[]";
        String generatedJavascript = options.getJavascriptOption().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        options.add((Object)o1);
        options.add((Object)o2);
        expectedJavascript = "[5,43]";
        generatedJavascript = options.getJavascriptOption().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testValues() {
        ArrayItemOptions options = new ArrayItemOptions();
        IntegerItemOptions o1 = new IntegerItemOptions(5);
        IntegerItemOptions o2 = new IntegerItemOptions(43);
        Assert.assertTrue((options.values().length == 0 ? 1 : 0) != 0);
        options.add((Object)o1);
        options.add((Object)o2);
        Assert.assertTrue((options.values().length == 2 ? 1 : 0) != 0);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

