/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.wiquery.core.javascript.JsStatement;

public class JsScopeContext
implements Serializable {
    private static final long serialVersionUID = -4223292444618777899L;
    private String[] scopeVariables;
    private List<JsStatement> statements;

    public JsScopeContext(String ... scopeVariables) {
        this.scopeVariables = scopeVariables;
        this.statements = new ArrayList<JsStatement>();
    }

    public JsStatement self() {
        JsStatement statement = new JsStatement();
        this.statements.add(statement);
        return statement.self();
    }

    public JsStatement var(String variable) {
        JsStatement statement = new JsStatement();
        this.statements.add(statement);
        return statement.append(variable);
    }

    public JsStatement append(CharSequence javascriptCode) {
        JsStatement statement = new JsStatement();
        this.statements.add(statement);
        return statement.append(javascriptCode);
    }

    CharSequence scopeDeclaration() {
        if (this.scopeVariables.length == 0) {
            return "";
        }
        StringBuilder scopeDeclaration = new StringBuilder();
        scopeDeclaration.append(this.scopeVariables[0]);
        for (int i = 1; i < this.scopeVariables.length; ++i) {
            scopeDeclaration.append(", ");
            scopeDeclaration.append(this.scopeVariables[i]);
        }
        return scopeDeclaration;
    }

    CharSequence render() {
        StringBuilder stringBuilder = new StringBuilder();
        for (JsStatement statement : this.statements) {
            stringBuilder.append("\t");
            stringBuilder.append(statement.render());
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }
}

