/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.tester.matchers;

import java.lang.reflect.Array;
import org.apache.wicket.Component;
import org.wicketstuff.wiquery.tester.matchers.AndMatcher;
import org.wicketstuff.wiquery.tester.matchers.ChildMatches;
import org.wicketstuff.wiquery.tester.matchers.ComponentIdMatcher;
import org.wicketstuff.wiquery.tester.matchers.ComponentMatcher;
import org.wicketstuff.wiquery.tester.matchers.ComponentTypeMatcher;
import org.wicketstuff.wiquery.tester.matchers.ModelMatcher;
import org.wicketstuff.wiquery.tester.matchers.OrMatcher;
import org.wicketstuff.wiquery.tester.matchers.ParentMatches;
import org.wicketstuff.wiquery.tester.matchers.PropertyExpressionMatcher;

public class ComponentMatchers {
    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return ComponentMatchers.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static AndMatcher and(ComponentMatcher left, ComponentMatcher right) {
        return new AndMatcher(left, right);
    }

    public static AndMatcher and(ComponentMatcher first, ComponentMatcher second, ComponentMatcher ... others) {
        if (others == null || others.length == 0) {
            return ComponentMatchers.and(first, second);
        }
        ComponentMatcher firstOfOthers = others[0];
        ComponentMatcher[] remainderOfOthers = (ComponentMatcher[])ComponentMatchers.copyOfRange(others, 1, others.length - 1, ComponentMatcher[].class);
        return ComponentMatchers.and(first, ComponentMatchers.and(second, firstOfOthers, remainderOfOthers));
    }

    public static OrMatcher or(ComponentMatcher left, ComponentMatcher right) {
        return new OrMatcher(left, right);
    }

    public static ComponentIdMatcher withId(String id) {
        return new ComponentIdMatcher(id);
    }

    public static PropertyExpressionMatcher forProperty(String expression) {
        return new PropertyExpressionMatcher(expression);
    }

    public static ComponentTypeMatcher ofType(Class<? extends Component> type) {
        return new ComponentTypeMatcher(type);
    }

    public static ModelMatcher forModel(Object modelObject) {
        return new ModelMatcher(modelObject);
    }

    public static ParentMatches parentMatches(ComponentMatcher matcher) {
        return new ParentMatches(matcher);
    }

    public static ChildMatches childMatches(ComponentMatcher matcher) {
        return new ChildMatches(matcher);
    }
}

