/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yav;

import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.validator.PatternValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

public class WicketMessageBuilder {
    private int index = 0;

    public String requiredMessage(Component component) {
        return this.addToBuffer(component.getId(), "required", this.escapeJavaScriptString(this.formatMessage(component, "Required")));
    }

    public String equalFieldMessage(FormComponent formComponent1, FormComponent formComponent2) {
        return this.addToBuffer(formComponent2.getId(), "equal|$" + formComponent1.getId(), this.escapeJavaScriptString(this.formatEqualFieldMessage((Component)formComponent1, (Component)formComponent2, "EqualPasswordInputValidator")));
    }

    public String rangeMessage(Component component, RangeValidator rangeValidator) {
        String minValue = rangeValidator.getMinimum().toString();
        String maxValue = rangeValidator.getMaximum().toString();
        return this.addToBuffer(component.getId(), "numrange|" + minValue + "-" + maxValue, this.escapeJavaScriptString(this.formatRangeMessage(component, "NumberValidator.range", minValue, maxValue)));
    }

    public String lengthBetweenMessage(Component component, StringValidator.LengthBetweenValidator lengthBetweenValidator) {
        String minimum = String.valueOf(lengthBetweenValidator.getMinimum());
        String maximum = String.valueOf(lengthBetweenValidator.getMaximum());
        String minMessage = this.addToBuffer(component.getId(), "minlength|" + minimum, this.escapeJavaScriptString(this.formatRangeMessage(component, "NumberValidator.range", minimum, maximum)));
        String maxMessage = this.addToBuffer(component.getId(), "maxlength|" + maximum, this.escapeJavaScriptString(this.formatRangeMessage(component, "NumberValidator.range", minimum, maximum)));
        return minMessage + maxMessage;
    }

    public String exactLengthMessage(Component component, StringValidator.ExactLengthValidator exactLengthValidator) {
        int length = exactLengthValidator.getLength();
        String minMessage = this.addToBuffer(component.getId(), "minlength|" + length, this.escapeJavaScriptString(this.formatExactLengthMessage(component, "StringValidator.exact", length)));
        String maxMessage = this.addToBuffer(component.getId(), "maxlength|" + length, this.escapeJavaScriptString(this.formatExactLengthMessage(component, "StringValidator.exact", length)));
        return minMessage + maxMessage;
    }

    public String minimumMessage(Component component, StringValidator.MinimumLengthValidator minimumLengthValidator) {
        String value = String.valueOf(minimumLengthValidator.getMinimum());
        return this.addToBuffer(component.getId(), "minlength|" + value, this.escapeJavaScriptString(this.formatMinimumMessage(component, "StringValidator.minimum", value)));
    }

    public String maximumMessage(Component component, StringValidator.MaximumLengthValidator maximumLengthValidator) {
        String value = String.valueOf(maximumLengthValidator.getMaximum());
        return this.addToBuffer(component.getId(), "maxlength|" + value, this.escapeJavaScriptString(this.formatMaximumMessage(component, "StringValidator.maximum", value)));
    }

    public String patternMessage(Component component, PatternValidator patternValidator) {
        return this.addToBuffer(component.getId(), "regexp|" + patternValidator.getPattern(), this.escapeJavaScriptString(this.formatPatternMessage(component, "PatternValidator", patternValidator.getPattern())));
    }

    public String emailMessage(Component component) {
        return this.addToBuffer(component.getId(), "email", this.escapeJavaScriptString(this.formatMessage(component, "EmailAddressValidator")));
    }

    public String typeConverterDateMessage(FormComponent formComponent, String converterClassName) {
        return this.addToBuffer(formComponent.getId(), "date", this.escapeJavaScriptString(this.formatTypeMessage(formComponent, converterClassName)));
    }

    public String typeConverterIntegerMessage(FormComponent formComponent, String converterClassName) {
        return this.addToBuffer(formComponent.getId(), "integer", this.escapeJavaScriptString(this.formatTypeMessage(formComponent, converterClassName)));
    }

    public String typeConverterDecimalMessage(FormComponent formComponent, String converterClassName) {
        return this.addToBuffer(formComponent.getId(), "double", this.escapeJavaScriptString(this.formatTypeMessage(formComponent, converterClassName)));
    }

    private String getWicketMessage(Component component, String wicketMsgId) {
        String result;
        try {
            result = component.getString(component.getId() + "." + wicketMsgId);
        }
        catch (Exception ex1) {
            try {
                result = component.getString(wicketMsgId);
            }
            catch (Exception ex2) {
                result = "";
            }
        }
        return result;
    }

    private String getWicketConverterMessage(FormComponent formComponent) {
        Class clazz = formComponent.getType();
        IConverter converter = formComponent.getConverter(clazz);
        String wicketMessage = this.getWicketMessage((Component)formComponent, converter.getClass().getSimpleName());
        if (wicketMessage == null || wicketMessage.length() == 0) {
            wicketMessage = this.getWicketMessage((Component)formComponent, "IConverter");
        }
        return wicketMessage;
    }

    private String formatMessage(Component component, String ruleType) {
        return this.replaceInputAndLabelAndNameBy(this.getWicketMessage(component, ruleType), component.getId());
    }

    private String formatTypeMessage(FormComponent formComponent, String type) {
        String customMessage = this.getWicketConverterMessage(formComponent);
        customMessage = this.replaceInputAndLabelAndNameBy(customMessage, formComponent.getId());
        return customMessage.replace("${type}", type);
    }

    private String formatEqualFieldMessage(Component component1, Component component2, String ruleType) {
        String customMessage = this.getWicketMessage(component2, ruleType);
        customMessage = customMessage.replace("${label0}", component1.getId());
        return customMessage.replace("${label1}", component2.getId());
    }

    private String formatRangeMessage(Component component, String ruleType, String minimumValue, String maximumValue) {
        String customMessage = this.formatMessage(component, ruleType);
        customMessage = customMessage.replace("${minimum}", minimumValue);
        return customMessage.replace("${maximum}", maximumValue);
    }

    private String formatExactLengthMessage(Component component, String ruleType, int length) {
        String customMessage = this.formatMessage(component, ruleType);
        return customMessage.replace("${exact}", String.valueOf(String.valueOf(length)));
    }

    private String formatMinimumMessage(Component component, String ruleType, String minimum) {
        String customMessage = this.formatMessage(component, ruleType);
        return customMessage.replace("${minimum}", minimum);
    }

    private String formatMaximumMessage(Component component, String ruleType, String maximum) {
        String customMessage = this.formatMessage(component, ruleType);
        return customMessage.replace("${maximum}", maximum);
    }

    private String formatPatternMessage(Component component, String ruleType, Pattern pattern) {
        String customMessage = this.formatMessage(component, ruleType);
        return customMessage.replace("${pattern}", pattern.toString());
    }

    private String replaceInputAndLabelAndNameBy(String string, String componentId) {
        return string.replace("${input}", componentId).replace("${name}", componentId).replace("${label}", componentId);
    }

    private String escapeJavaScriptString(String message) {
        return message.replace("'", "\\'");
    }

    private String addToBuffer(String componentId, String rule, String customMessage) {
        if (customMessage == null) {
            return this.addToBuffer(componentId, rule);
        }
        return "rules[" + this.index++ + "]='" + componentId + "|" + rule + "|" + customMessage + "';\n";
    }

    private String addToBuffer(String componentId, String rule) {
        return "rules[" + this.index++ + "]='" + componentId + "|" + rule + "';\n";
    }
}

