/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yav;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.IValueMap;
import org.wicketstuff.yav.YavFormComponentVisitor;
import org.wicketstuff.yav.alerts.AlertType;

public class YavBehavior
extends AbstractBehavior
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private AlertType alertType = AlertType.INNER_HTML;

    public YavBehavior() {
    }

    public YavBehavior(AlertType alertType) {
        this.alertType = alertType;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)new CompressedResourceReference(YavBehavior.class, "style/yav-style.css"));
        this.addJavascriptReference(response, "yav.js");
        this.addJavascriptReference(response, "yav-config.js");
        this.addJavascriptReference(response, "util.js");
        response.renderOnLoadJavascript("yavInit()");
    }

    private void addJavascriptReference(IHeaderResponse response, String resource) {
        response.renderJavascriptReference((ResourceReference)new JavascriptResourceReference(YavBehavior.class, resource));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (!Form.class.isAssignableFrom(component.getClass())) {
            throw new WicketRuntimeException("This behavior is only applicable on a Form component");
        }
        Form form = (Form)component;
        String formName = this.verifyFormName(form, tag);
        tag.put("onsubmit", (CharSequence)("return yav.performCheck('" + formName + "', rules);"));
        AppendingStringBuffer buffer = new AppendingStringBuffer((CharSequence)"<script>\n");
        buffer.append("var rules=new Array();\n");
        form.visitFormComponents((FormComponent.IVisitor)new YavFormComponentVisitor(buffer, form));
        buffer.append("function yavInit() {\n");
        buffer.append("    yav.init('" + formName + "', rules);\n");
        buffer.append("}\n");
        buffer.append("</script>\n");
        Response response = RequestCycle.get().getResponse();
        response.write((CharSequence)buffer.toString());
    }

    private String verifyFormName(Form form, ComponentTag tag) {
        IValueMap attributes = tag.getAttributes();
        String value = attributes.getString("name");
        if (value == null) {
            value = form.getId();
            tag.put("name", (CharSequence)value);
        }
        return value;
    }

    public AlertType getAlertType() {
        return this.alertType;
    }

    public void setAlertType(AlertType alertType) {
        this.alertType = alertType;
    }
}

