/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yav;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.validation.EqualInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.DateConverter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.apache.wicket.validation.validator.PatternValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.wicketstuff.yav.WicketMessageBuilder;

public class YavFormComponentVisitor
implements FormComponent.IVisitor {
    private AppendingStringBuffer buffer;
    private Collection<IFormValidator> formValidators;
    private WicketMessageBuilder messageBuilder;
    private boolean addedDateInfo = false;
    private boolean addedNumberInfo = false;

    public YavFormComponentVisitor(AppendingStringBuffer buffer, Form parentForm) {
        this.formValidators = parentForm.getFormValidators();
        this.messageBuilder = new WicketMessageBuilder();
        this.buffer = buffer;
    }

    public Object formComponent(IFormVisitorParticipant formComponent) {
        if (FormComponent.class.isAssignableFrom(formComponent.getClass())) {
            FormComponent component = (FormComponent)formComponent;
            if (component.isRequired()) {
                this.buffer.append(this.messageBuilder.requiredMessage((Component)component));
            }
            this.addYavRuleOnConverter(component);
            List validators = component.getValidators();
            for (IValidator validator : validators) {
                this.addYavRuleOnValidator(validator, (Component)component);
            }
            this.verifyExistingValidatorOnComponent(component);
        }
        return null;
    }

    private void verifyExistingValidatorOnComponent(FormComponent formComponent) {
        for (IFormValidator formValidator : this.formValidators) {
            if (!EqualInputValidator.class.isAssignableFrom(formValidator.getClass())) continue;
            FormComponent[] dependentFormComponents = formValidator.getDependentFormComponents();
            FormComponent formComponent1 = dependentFormComponents[0];
            FormComponent formComponent2 = dependentFormComponents[1];
            if (!formComponent2.equals(formComponent)) continue;
            this.buffer.append(this.messageBuilder.equalFieldMessage(formComponent1, formComponent2));
        }
    }

    private void addYavRuleOnConverter(FormComponent formComponent) {
        Class clazz = formComponent.getType();
        if (clazz == null) {
            return;
        }
        String className = clazz.getName();
        if (className.equals(Date.class.getName())) {
            this.overrideDateType(this.buffer);
            this.buffer.append(this.messageBuilder.typeConverterDateMessage(formComponent, clazz.getSimpleName()));
        } else if (className.equals(Integer.class.getName()) || className.equals(Integer.TYPE.getName()) || className.equals(Long.class.getName()) || className.equals(Long.TYPE.getClass()) || className.equals(Short.class.getName()) || className.equals(Short.TYPE.getClass()) || className.equals(BigInteger.class.getName())) {
            this.buffer.append(this.messageBuilder.typeConverterIntegerMessage(formComponent, clazz.getSimpleName()));
        } else if (className.equals(Float.class.getName()) || className.equals(Float.TYPE.getClass()) || className.equals(Double.class.getName()) || className.equals(Double.TYPE.getClass()) || className.equals(BigDecimal.class.getName())) {
            this.overrideDecimalType(this.buffer);
            this.buffer.append(this.messageBuilder.typeConverterDecimalMessage(formComponent, clazz.getSimpleName()));
        }
    }

    private void addYavRuleOnValidator(IValidator validator, Component component) {
        if (INullAcceptingValidator.class.isAssignableFrom(validator.getClass())) {
            if (StringValidator.class.isAssignableFrom(validator.getClass())) {
                this.addYavRuleForStringValidatorType(validator, component);
            }
        } else if (IValidator.class.isAssignableFrom(validator.getClass())) {
            this.addYavRuleForMinMaxRangeValidatorType(validator, component);
        }
    }

    private void overrideDecimalType(AppendingStringBuffer buffer) {
        if (!this.addedNumberInfo) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Session.get().getLocale());
            buffer.append("yav_config.DECIMAL_SEP='" + decimalFormatSymbols.getDecimalSeparator() + "';\n");
            buffer.append("yav_config.THOUSAND_SEP='" + decimalFormatSymbols.getGroupingSeparator() + "';\n");
            this.addedNumberInfo = true;
        }
    }

    private void overrideDateType(AppendingStringBuffer buffer) {
        if (!this.addedDateInfo) {
            DateFormat dateFormat;
            IConverter converter = Application.get().getConverterLocator().getConverter(Date.class);
            if (DateConverter.class.isAssignableFrom(converter.getClass()) && SimpleDateFormat.class.isAssignableFrom((dateFormat = ((DateConverter)converter).getDateFormat(Session.get().getLocale())).getClass())) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                String pattern = sdf.toPattern();
                if (pattern.indexOf("yyyy") == -1) {
                    pattern = pattern.replace("yy", "yyyy");
                }
                buffer.append("yav_config.DATE_FORMAT='" + pattern + "';\n");
            }
            this.addedDateInfo = true;
        }
    }

    private void addYavRuleForMinMaxRangeValidatorType(IValidator validator, Component component) {
        RangeValidator rangeValidator;
        if (RangeValidator.class.isAssignableFrom(validator.getClass()) && Number.class.isAssignableFrom((rangeValidator = (RangeValidator)validator).getMinimum().getClass())) {
            this.buffer.append(this.messageBuilder.rangeMessage(component, rangeValidator));
        }
    }

    private void addYavRuleForStringValidatorType(IValidator validator, Component component) {
        if (StringValidator.ExactLengthValidator.class.isAssignableFrom(validator.getClass())) {
            StringValidator.ExactLengthValidator exactLengthValidator = (StringValidator.ExactLengthValidator)validator;
            this.buffer.append(this.messageBuilder.exactLengthMessage(component, exactLengthValidator));
        } else if (StringValidator.MinimumLengthValidator.class.isAssignableFrom(validator.getClass())) {
            StringValidator.MinimumLengthValidator minimumLengthValidator = (StringValidator.MinimumLengthValidator)validator;
            this.buffer.append(this.messageBuilder.minimumMessage(component, minimumLengthValidator));
        } else if (StringValidator.MaximumLengthValidator.class.isAssignableFrom(validator.getClass())) {
            StringValidator.MaximumLengthValidator maximumLengthValidator = (StringValidator.MaximumLengthValidator)validator;
            this.buffer.append(this.messageBuilder.maximumMessage(component, maximumLengthValidator));
        } else if (StringValidator.LengthBetweenValidator.class.isAssignableFrom(validator.getClass())) {
            StringValidator.LengthBetweenValidator lengthBetweenValidator = (StringValidator.LengthBetweenValidator)validator;
            this.buffer.append(this.messageBuilder.lengthBetweenMessage(component, lengthBetweenValidator));
        } else if (PatternValidator.class.isAssignableFrom(validator.getClass())) {
            PatternValidator patternValidator = (PatternValidator)validator;
            if (EmailAddressValidator.class.isAssignableFrom(validator.getClass())) {
                this.buffer.append(this.messageBuilder.emailMessage(component));
            } else {
                this.buffer.append(this.messageBuilder.patternMessage(component, patternValidator));
            }
        }
    }
}

