/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.behavior.animation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.form.FormComponent;
import org.wicketstuff.yui.behavior.animation.YuiAnimEffect;
import org.wicketstuff.yui.helper.JSArray;
import org.wicketstuff.yui.helper.OnEvent;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YuiAnimation
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private List<YuiAnimEffect> effects = new ArrayList<YuiAnimEffect>();
    private List<AnimValueGroup> triggers = new ArrayList<AnimValueGroup>();
    private boolean isTriggeredByAttachedComponent = true;
    private Component component;
    private OnEvent onEvent;

    public YuiAnimation(OnEvent onEvent) {
        this.onEvent = onEvent;
    }

    public YuiAnimation(OnEvent onEvent, String triggerId) {
        this.onEvent = onEvent;
        this.addTrigger(triggerId);
        this.isTriggeredByAttachedComponent = false;
    }

    public YuiAnimation(OnEvent onEvent, Component component) {
        this.onEvent = onEvent;
        this.addTrigger(component);
        this.isTriggeredByAttachedComponent = false;
    }

    public YuiAnimation(OnEvent onEvent, Component component, FormComponent<?> element, String value) {
        this.onEvent = onEvent;
        this.addTrigger(component, element, value);
        this.isTriggeredByAttachedComponent = false;
    }

    public void bind(Component component) {
        this.component = component;
        this.component.setOutputMarkupId(true);
        component.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        component.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution(YuiAnimEffect.class, (String)"effects/effects.js")});
        component.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution(YuiAnimEffect.class, (String)"effects/tools.js")});
        component.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution(YuiAnimEffect.class, (String)"effects/animator.js")});
        if (this.isTriggeredByAttachedComponent) {
            this.addTrigger(this.component);
        }
    }

    public void renderHead(IHeaderResponse response) {
        StringBuffer buffer = new StringBuffer().append("var ").append(this.getAnimVar()).append(" = ").append(this.buildEffectsJS()).append("Wicket.yui.Animator.add(").append(this.getAnimValueGroups()).append(",").append("'").append((Object)this.getOnEvent()).append("'").append(",").append("'").append(this.getComponentId()).append("'").append(")");
        response.renderOnDomReadyJavascript(buffer.toString());
    }

    private String getAnimValueGroups() {
        JSArray triggers = new JSArray();
        for (AnimValueGroup aAvg : this.getTriggers()) {
            triggers.add(aAvg.newJS());
        }
        return triggers.toString();
    }

    private OnEvent getOnEvent() {
        return this.onEvent;
    }

    private String buildEffectsJS() {
        String js = this.buildEffectsJS(this.getAnimVar(), this.effects);
        return js.substring(js.indexOf("=") + 1, js.lastIndexOf(this.getAnimVar() + ".animate();"));
    }

    private String buildEffectsJS(String jsVar, List<YuiAnimEffect> effectslist) {
        int listsize = effectslist.size();
        if (listsize == 0) {
            return "";
        }
        YuiAnimEffect effect = effectslist.get(0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(jsVar).append("=").append("new ").append(effect.newEffectJS()).append("('").append(this.getComponentId()).append("',").append(effect.getAttributes()).append(",").append(effect.getOpts()).append(");");
        if (listsize > 1) {
            buffer.append(jsVar).append(".").append(effect.onCompleteJS()).append(".subscribe(function() {");
            buffer.append(this.buildEffectsJS(jsVar + listsize, effectslist.subList(1, listsize)));
            buffer.append("});");
        }
        buffer.append(jsVar).append(".").append("animate();");
        return buffer.toString();
    }

    private String getAnimVar() {
        return (Object)((Object)this.getOnEvent()) + "_" + this.getComponentId();
    }

    public String getComponentId() {
        return this.component.getMarkupId();
    }

    public List<YuiAnimEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(List<YuiAnimEffect> effects) {
        this.effects = effects;
    }

    public List<AnimValueGroup> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<AnimValueGroup> triggers) {
        this.triggers = triggers;
    }

    public boolean isTriggeredByAttachedComponent() {
        return this.isTriggeredByAttachedComponent;
    }

    public void setTriggeredByAttachedComponent(boolean isTriggeredByAttachedComponent) {
        this.isTriggeredByAttachedComponent = isTriggeredByAttachedComponent;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setOnEvent(OnEvent onEvent) {
        this.onEvent = onEvent;
    }

    public YuiAnimation addEffect(YuiAnimEffect effect) {
        this.getEffects().add(effect);
        return this;
    }

    public YuiAnimation addTrigger(String triggerId) {
        this.getTriggers().add(new AnimValueGroup(triggerId, null, null, false));
        return this;
    }

    public YuiAnimation addTrigger(Component component) {
        this.getTriggers().add(new AnimValueGroup(component, null, null, false));
        return this;
    }

    private YuiAnimation addTrigger(Component component, FormComponent<?> element, String value) {
        this.getTriggers().add(new AnimValueGroup(component, element, value, false));
        return this;
    }

    public YuiAnimation addTriggerOnValue(Component component, FormComponent<?> element, String value) {
        this.getTriggers().add(new AnimValueGroup(component, element, value, true));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimValueGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        FormComponent<?> element;
        String value;
        Component triggerComponent;
        String triggerId;
        boolean isAnimateOnValue;
        String anim;

        public AnimValueGroup(String triggerId, FormComponent<?> element, String value, boolean animateOnValue) {
            this.triggerId = triggerId;
            this.isAnimateOnValue = animateOnValue;
            this.element = element;
            this.value = value;
        }

        public AnimValueGroup(Component triggerComponent, FormComponent<?> element, String value, boolean animateOnValue) {
            this.triggerComponent = triggerComponent;
            this.isAnimateOnValue = animateOnValue;
            this.element = element;
            this.value = value;
            if (this.element != null) {
                this.element.setOutputMarkupId(true);
            }
            if (this.triggerComponent != null) {
                this.triggerComponent.setOutputMarkupId(true);
            }
        }

        public String newJS() {
            StringBuffer script = new StringBuffer();
            script.append("new Wicket.yui.AnimValueGroup(").append("'").append(this.getTriggerId()).append("'").append(",").append(YuiAnimation.this.getAnimVar()).append(",").append(this.getElementId()).append(",").append(this.getElementValue()).append(",").append(this.isAnimateOnValue).append(")");
            return script.toString();
        }

        private String getElementValue() {
            String value = null;
            if (this.value != null) {
                value = "\"" + this.value + "\"";
            }
            return value;
        }

        private String getElementId() {
            String markupId = null;
            if (this.element != null) {
                markupId = "\"" + this.element.getMarkupId() + "\"";
            }
            return markupId;
        }

        private String getTriggerId() {
            if (this.triggerComponent != null) {
                return this.triggerComponent.getMarkupId();
            }
            return this.triggerId;
        }
    }
}

