/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.behavior.dragdrop;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.wicketstuff.yui.behavior.dragdrop.YuiDDTarget;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;

public abstract class YuiDDList
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String MODULE_NAME = "wicket_yui_ddlist";
    private static final ResourceReference MODULE_REF_JS = new ResourceReference(YuiDDList.class, "YuiDDList.js");
    private static final String[] MODULE_REQUIRES = new String[]{"dragdrop", "animation"};
    private static final String IDX = "idx";
    private static final String DOI = "doi";
    protected static final String PREFIX = "YDDL_";
    private String listId;
    private String groupId = "default";

    public YuiDDList() {
    }

    public YuiDDList(String groupId) {
        this.groupId = groupId;
    }

    protected void onBind() {
        super.onBind();
        this.getComponent().setOutputMarkupId(true);
        this.listId = this.getComponent().getMarkupId();
        final String initScript = this.getInitJS();
        this.getComponent().add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_REF_JS, MODULE_REQUIRES){

            public String onSuccessJS() {
                return initScript;
            }
        })});
    }

    private String getInitJS() {
        StringBuffer js = new StringBuffer();
        String varId = PREFIX + this.listId;
        js.append("var " + varId + " = new YAHOO.Wicket.DDList(\"" + this.listId + "\",\"" + this.getGroupId() + "\"," + this.getConfig() + "," + this.getCallbackWicket() + ");\n");
        js.append(varId).append(".setHandleElId(\"" + this.listId + "\");\n");
        return js.toString();
    }

    private String getCallbackWicket() {
        return "function () { " + this.getCallbackScript() + " }";
    }

    protected CharSequence getCallbackScript(boolean onlyTargetActivePage) {
        StringBuffer params = new StringBuffer();
        params.append(this.getCallbackUrl(onlyTargetActivePage)).append("'");
        params.append(" + '&").append(IDX).append("=' + ").append("this.idx");
        params.append(" + '&").append(DOI).append("=' + ").append("this.doi");
        CharSequence s = this.generateCallbackScript("wicketAjaxGet('" + params.toString());
        return s;
    }

    private String getGroupId() {
        return this.groupId;
    }

    protected String getConfig() {
        return "{}";
    }

    protected void respond(final AjaxRequestTarget target) {
        String idx = RequestCycle.get().getRequest().getParameter(IDX);
        final String doi = RequestCycle.get().getRequest().getParameter(DOI);
        final int index = Integer.parseInt(idx);
        this.getComponent().getPage().visitChildren((Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                if (component.getMarkupId().equals(doi)) {
                    Component validTargetItem = component;
                    List behaviors = component.getBehaviors();
                    for (IBehavior behavior : behaviors) {
                        if (!(behavior instanceof YuiDDTarget)) continue;
                        YuiDDTarget ddTarget = (YuiDDTarget)behavior;
                        ddTarget.onDrop(target, YuiDDList.this.getComponent());
                        validTargetItem = null;
                    }
                    YuiDDList.this.onDrop(target, index, validTargetItem);
                }
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    protected abstract void onDrop(AjaxRequestTarget var1, int var2, Component var3);
}

