/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wicketstuff.yui.helper.TokenSeparatedValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NameValuePair<T>
extends TokenSeparatedValues {
    private static final long serialVersionUID = 1L;
    Map<String, Object> propertyMap = new HashMap<String, Object>();

    public T add(String element, Object object) {
        if (this.isValid(element, object)) {
            if (object instanceof Boolean) {
                this.propertyMap.put(element, object);
            } else {
                String value = object.toString();
                if (!(value.startsWith("{") || value.startsWith("[") || value.startsWith("\""))) {
                    try {
                        Float.parseFloat(value);
                    }
                    catch (Exception e) {
                        value = this.wrapValue(value);
                    }
                }
                this.propertyMap.put(element, value);
            }
        }
        return (T)this;
    }

    public T add(NameValuePair another) {
        Map<String, Object> am = another.propertyMap;
        for (Map.Entry<String, Object> entry : am.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    public T add(String element, int int_value) {
        return this.add(element, Integer.toString(int_value));
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.propertyMap.entrySet()) {
            list.add(entry.getKey() + this.getNameValueSeparator() + entry.getValue());
        }
        return list;
    }

    public boolean isValid(String key, Object value) {
        return true;
    }

    public abstract String getNameValueSeparator();

    protected String wrapValue(String value) {
        return "\"" + value + "\"";
    }
}

