/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.anim;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.anim.AnimGroup;
import org.wicketstuff.yui.markup.html.anim.AnimOption;
import org.wicketstuff.yui.markup.html.anim.AnimSettings;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;

public class AnimBox
extends Panel {
    private static final long serialVersionUID = 1L;
    private AnimSettings settings;
    private String javaScriptId;
    private String easing;
    private double duration;
    private int maxSelection;
    private String message;

    public AnimBox(String id, final int index, AnimOption animSelectOption, AnimSettings settings) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        this.settings = settings;
        this.easing = settings.getEasing();
        this.duration = settings.getDuration();
        this.maxSelection = settings.getMaxSelection();
        this.message = settings.getMessage();
        ImgStyle style = new ImgStyle("imgStyle");
        this.add(new Component[]{style});
        style.add(new Component[]{new AnimSelectBox("defaultImg", index, "DefaultImg", animSelectOption.getDefaultImg())});
        style.add(new Component[]{new AnimSelectBox("defaultImgOver", index, "DefaultImgOver", animSelectOption.getDefaultImgOver())});
        style.add(new Component[]{new AnimSelectBox("selectedImg", index, "SelectedImg", animSelectOption.getSelectedImg())});
        style.add(new Component[]{new AnimSelectBox("selectedImgOver", index, "SelectedImgOver", animSelectOption.getSelectedImgOver())});
        Label animSelect = new Label("animSelectScript", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return AnimBox.this.getAnimSelectInitializationScript(index);
            }
        });
        animSelect.setEscapeModelStrings(false);
        this.add(new Component[]{animSelect});
    }

    protected String getAnimSelectInitializationScript(int index) {
        PackagedTextTemplate template = new PackagedTextTemplate(AnimBox.class, "anim.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(7);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("boxId", new Integer(index));
        variables.put("easing", "YAHOO.util.Easing." + this.easing);
        variables.put("duration", new Double(this.duration));
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("noOfBoxes", new Integer(this.settings.getAnimOptionList().size()));
        if (this.message == null || this.message.equals("")) {
            this.message = "Up to " + this.maxSelection + " selections allowed!";
        }
        variables.put("message", this.message);
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = ((AnimGroup)((Object)this.findParent(AnimGroup.class))).getMarkupId();
    }

    private final class ImgStyle
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ImgStyle(String id) {
            super(id);
            this.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return "width:" + AnimBox.this.settings.getWidth() + "px; height:" + AnimBox.this.settings.getHeight() + "px";
                }
            })});
        }
    }

    private final class AnimSelectBox
    extends FormComponent
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public AnimSelectBox(String id, final int count, final String name, YuiImage yuiImage) {
            super(id);
            this.add(new IBehavior[]{new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return name + count + "_" + AnimBox.this.javaScriptId;
                }
            })});
            this.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    if (name.equals("DefaultImg")) {
                        List<CSSInlineStyle> aCSSInlineStyleList = AnimBox.this.settings.getDefaultImgStyleList();
                        CSSInlineStyle aCSSInlineStyle = aCSSInlineStyleList.get(0);
                        return aCSSInlineStyle.getStyle();
                    }
                    if (name.equals("DefaultImgOver")) {
                        List<CSSInlineStyle> aCSSInlineStyleList = AnimBox.this.settings.getDefaultImgOverStyleList();
                        CSSInlineStyle aCSSInlineStyle = aCSSInlineStyleList.get(0);
                        return aCSSInlineStyle.getStyle();
                    }
                    if (name.equals("SelectedImg")) {
                        List<CSSInlineStyle> aCSSInlineStyleList = AnimBox.this.settings.getSelectedImgStyleList();
                        CSSInlineStyle aCSSInlineStyle = aCSSInlineStyleList.get(0);
                        return aCSSInlineStyle.getStyle();
                    }
                    if (name.equals("SelectedImgOver")) {
                        List<CSSInlineStyle> aCSSInlineStyleList = AnimBox.this.settings.getSelectedImgOverStyleList();
                        CSSInlineStyle aCSSInlineStyle = aCSSInlineStyleList.get(0);
                        return aCSSInlineStyle.getStyle();
                    }
                    return new String("");
                }
            })});
        }
    }
}

