/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.anim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.anim.AnimOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String easing;
    private double duration;
    private int maxSelection;
    private String message;
    private List<AnimOption> animOptionList;
    private List<CSSInlineStyle> defaultImgStyleList = new ArrayList<CSSInlineStyle>();
    private List<CSSInlineStyle> defaultImgOverStyleList = new ArrayList<CSSInlineStyle>();
    private List<CSSInlineStyle> selectedImgStyleList = new ArrayList<CSSInlineStyle>();
    private List<CSSInlineStyle> selectedImgOverStyleList = new ArrayList<CSSInlineStyle>();
    private int width;
    private int height;

    public static AnimSettings getDefault(String easing, double duration, int maxSelection, List<AnimOption> animOptionList) {
        AnimSettings settings = new AnimSettings();
        settings.setResources(easing, duration, maxSelection, animOptionList);
        return settings;
    }

    public void setResources(String easing, double duration, int maxSelection, List<AnimOption> animOptionList) {
        this.setEasing(easing);
        this.setDuration(duration);
        this.setMaxSelection(maxSelection);
        this.setAnimOptionList(animOptionList);
        this.setImageResources(animOptionList);
    }

    public static AnimSettings getDefault(String easing, double duration, int maxSelection, String message, List<AnimOption> animOptionList) {
        AnimSettings settings = new AnimSettings();
        settings.setResources(easing, duration, maxSelection, message, animOptionList);
        return settings;
    }

    public void setResources(String easing, double duration, int maxSelection, String message, List<AnimOption> animOptionList) {
        this.setEasing(easing);
        this.setDuration(duration);
        this.setMaxSelection(maxSelection);
        this.setMessage(message);
        this.setAnimOptionList(animOptionList);
        this.setImageResources(animOptionList);
    }

    public void setImageResources(List<AnimOption> animOptionList) {
        for (int i = animOptionList.size() - 1; i >= 0; --i) {
            YuiImage defaultImg = animOptionList.get(i).getDefaultImg();
            YuiImage defaultImgOver = animOptionList.get(i).getDefaultImgOver();
            YuiImage selectedImg = animOptionList.get(i).getSelectedImg();
            YuiImage selectedImgOver = animOptionList.get(i).getSelectedImgOver();
            ResourceReference defaultImgRR = new ResourceReference(AnimSettings.class, defaultImg.getFileName());
            ResourceReference defaultImgOverRR = new ResourceReference(AnimSettings.class, defaultImgOver.getFileName());
            ResourceReference selectedImgRR = new ResourceReference(AnimSettings.class, selectedImg.getFileName());
            ResourceReference selectedImgOverRR = new ResourceReference(AnimSettings.class, selectedImgOver.getFileName());
            ImageResourceInfo defaultImgInfo = new ImageResourceInfo(defaultImgRR);
            int defaultImgWidth = defaultImgInfo.getWidth();
            int defaultImgHeight = defaultImgInfo.getHeight();
            ImageResourceInfo defaultImgOverInfo = new ImageResourceInfo(defaultImgOverRR);
            int defaultImgOverWidth = defaultImgOverInfo.getWidth();
            int defaultImgOverHeight = defaultImgOverInfo.getHeight();
            ImageResourceInfo selectedImgInfo = new ImageResourceInfo(selectedImgRR);
            int selectedImgWidth = selectedImgInfo.getWidth();
            int selectedImgHeight = selectedImgInfo.getHeight();
            ImageResourceInfo selectedImgOverInfo = new ImageResourceInfo(selectedImgOverRR);
            int selectedImgOverWidth = selectedImgOverInfo.getWidth();
            int selectedImgOverHeight = selectedImgOverInfo.getHeight();
            CSSInlineStyle defaultImgStyle = new CSSInlineStyle();
            defaultImgStyle.add("background", "url(" + RequestCycle.get().urlFor(defaultImgRR) + ")");
            defaultImgStyle.add("width", defaultImgWidth + "px");
            defaultImgStyle.add("height", defaultImgHeight + "px");
            CSSInlineStyle defaultImgOverStyle = new CSSInlineStyle();
            defaultImgOverStyle.add("background", "url(" + RequestCycle.get().urlFor(defaultImgOverRR) + ")");
            defaultImgOverStyle.add("width", defaultImgOverWidth + "px");
            defaultImgOverStyle.add("height", defaultImgOverHeight + "px");
            CSSInlineStyle selectedImgStyle = new CSSInlineStyle();
            selectedImgStyle.add("background", "url(" + RequestCycle.get().urlFor(selectedImgRR) + ")");
            selectedImgStyle.add("width", selectedImgWidth + "px");
            selectedImgStyle.add("height", selectedImgHeight + "px");
            CSSInlineStyle selectedImgOverStyle = new CSSInlineStyle();
            selectedImgOverStyle.add("background", "url(" + RequestCycle.get().urlFor(selectedImgOverRR) + ")");
            selectedImgOverStyle.add("width", selectedImgOverWidth + "px");
            selectedImgOverStyle.add("height", selectedImgOverHeight + "px");
            this.defaultImgStyleList.add(defaultImgStyle);
            this.defaultImgOverStyleList.add(defaultImgOverStyle);
            this.selectedImgStyleList.add(selectedImgStyle);
            this.selectedImgOverStyleList.add(selectedImgOverStyle);
            this.width = defaultImgWidth;
            this.height = defaultImgHeight;
        }
    }

    public List<AnimOption> getAnimOptionList() {
        return this.animOptionList;
    }

    public void setAnimOptionList(List<AnimOption> animOptionList) {
        this.animOptionList = animOptionList;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getEasing() {
        return this.easing;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public int getMaxSelection() {
        return this.maxSelection;
    }

    public void setMaxSelection(int maxSelection) {
        this.maxSelection = maxSelection;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<CSSInlineStyle> getDefaultImgOverStyleList() {
        return this.defaultImgOverStyleList;
    }

    public void setDefaultImgOverStyleList(List<CSSInlineStyle> defaultImgOverStyleList) {
        this.defaultImgOverStyleList = defaultImgOverStyleList;
    }

    public List<CSSInlineStyle> getDefaultImgStyleList() {
        return this.defaultImgStyleList;
    }

    public void setDefaultImgStyleList(List<CSSInlineStyle> defaultImgStyleList) {
        this.defaultImgStyleList = defaultImgStyleList;
    }

    public List<CSSInlineStyle> getSelectedImgOverStyleList() {
        return this.selectedImgOverStyleList;
    }

    public void setSelectedImgOverStyleList(List<CSSInlineStyle> selectedImgOverStyleList) {
        this.selectedImgOverStyleList = selectedImgOverStyleList;
    }

    public List<CSSInlineStyle> getSelectedImgStyleList() {
        return this.selectedImgStyleList;
    }

    public void setSelectedImgStyleList(List<CSSInlineStyle> selectedImgStyleList) {
        this.selectedImgStyleList = selectedImgStyleList;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

