/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.anim.stretch;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.wicketstuff.yui.behavior.animation.YuiEasing;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;

public abstract class StretchPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String EXPANDED = "EXPANDED";
    public static final String COLLAPSED = "COLLAPSED";
    private Label label;
    private Component stretchPanel;
    private int collapsedHeight = 0;
    private int expandedHeight = 200;
    private double delay = 1.0;
    private YuiEasing easing = YuiEasing.easeOut;
    private String defaultState = "COLLAPSED";

    public StretchPanel(String id, String toggleLabel) {
        this(id, (IModel)new Model((Serializable)((Object)toggleLabel)));
    }

    public StretchPanel(String id, IModel toggleLabel) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        this.label = new Label("stretchToggle", toggleLabel);
        this.label.setOutputMarkupId(true);
        this.stretchPanel = this.getStretchPanel("stretcher");
        this.stretchPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.label});
        this.add(new Component[]{this.stretchPanel});
    }

    public void renderHead(HtmlHeaderContainer container) {
        super.renderHead(container);
        IHeaderResponse headerResponse = container.getHeaderResponse();
        AppendingStringBuffer asb = new AppendingStringBuffer((CharSequence)"var tog = document.getElementById('");
        asb.append(this.label.getMarkupId());
        asb.append("');\n");
        asb.append("var slide = document.getElementById('");
        asb.append(this.stretchPanel.getMarkupId());
        asb.append("');\n");
        asb.append("slideFunction = function(e, obj) {\n");
        asb.append("var att = {height: { to: " + this.expandedHeight + " }};\n");
        asb.append("if(this.style.height == '" + this.expandedHeight + "px') {\n");
        asb.append("att = {height: { to: " + this.collapsedHeight + " }};\n");
        asb.append("}\n");
        asb.append("var anim = new YAHOO.util.Anim(this, att, " + this.delay + ", " + this.easing.constant() + ");\n");
        asb.append("anim.animate();\n");
        asb.append("}\n");
        asb.append("YAHOO.util.Event.on(tog, 'click', slideFunction, slide, true);\n");
        int initialHeight = this.collapsedHeight;
        if (EXPANDED.equals(this.defaultState)) {
            initialHeight = this.expandedHeight;
        }
        asb.append("var att = {height: { to: " + initialHeight + " }};\n");
        asb.append("var anim = new YAHOO.util.Anim(slide, att, " + this.delay + ", YAHOO.util.Easing." + (Object)((Object)this.easing) + ");\n");
        asb.append("anim.animate();\n");
        headerResponse.renderOnDomReadyJavascript(asb.toString());
    }

    protected abstract Component getStretchPanel(String var1);

    public void setCollapsedHeight(int collapsedHeight) {
        this.collapsedHeight = collapsedHeight;
    }

    public void setExpandedHeight(int expandedHeight) {
        this.expandedHeight = expandedHeight;
    }

    public void setDelayTime(double delay) {
        this.delay = delay;
    }

    public void setEasing(YuiEasing yuiEasing) {
        this.easing = yuiEasing;
    }

    public void setDefaultState(String defaultState) {
        this.defaultState = defaultState;
    }
}

