/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animation.thumbnail;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.yui.behavior.animation.YuiAnim;
import org.wicketstuff.yui.behavior.animation.YuiAnimEffect;
import org.wicketstuff.yui.behavior.animation.YuiAnimation;
import org.wicketstuff.yui.behavior.animation.YuiEasing;
import org.wicketstuff.yui.helper.Attributes;
import org.wicketstuff.yui.helper.OnEvent;

public abstract class AnimatedItem
extends Panel {
    private static final long serialVersionUID = 1L;
    private Component onloadItem;
    private Component mouseoverItem;
    private Component onclickItem;
    private FormComponent element;
    private String selectValue;
    private String unselectValue;
    private YuiAnimation onunselectAnimation;
    public static Attributes SHOW_ATTRIBUTE = new Attributes("zIndex", 0, 1);
    public static Attributes HIDE_ATTRIBUTE = new Attributes("zIndex", 1, 0);

    public AnimatedItem(String id) {
        super(id);
        this.add(new IBehavior[]{HeaderContributor.forCss(AnimatedItem.class, (String)"AnimatedItem.css")});
    }

    public AnimatedItem(String id, FormComponent element, String selectValue, String unselectValue) {
        this(id);
        this.element = element;
        this.selectValue = selectValue;
        this.unselectValue = unselectValue;
    }

    public void init() {
        this.onloadItem = this.newOnloadItem("onload_item");
        this.add(new Component[]{this.onloadItem});
        this.mouseoverItem = this.newMouseoverItem("mouseover_item");
        this.add(new Component[]{this.mouseoverItem});
        this.onclickItem = this.newOnclickItem("onclick_item");
        this.add(new Component[]{this.onclickItem});
        this.mouseoverItem.add(new IBehavior[]{new YuiAnimation(OnEvent.mouseover, this.onloadItem).addEffect(this.mouseoverEffect())});
        this.mouseoverItem.add(new IBehavior[]{new YuiAnimation(OnEvent.mouseout, this.mouseoverItem).addEffect(this.mouseoutEffect())});
        this.onclickItem.add(new IBehavior[]{new YuiAnimation(OnEvent.click, this.mouseoverItem, this.getElement(), this.getSelectValue()).addEffect(this.onselectEffect())});
        IBehavior[] iBehaviorArray = new IBehavior[1];
        this.onunselectAnimation = new YuiAnimation(OnEvent.click, this.onclickItem, this.getElement(), this.getUnselectValue()).addEffect(this.onunselectEffect());
        iBehaviorArray[0] = this.onunselectAnimation;
        this.onclickItem.add(iBehaviorArray);
    }

    public YuiAnimEffect onunselectEffect() {
        return new YuiAnim(YuiAnimEffect.Type.Anim, HIDE_ATTRIBUTE, 1, YuiEasing.easeNone);
    }

    public YuiAnimEffect onselectEffect() {
        return new YuiAnim(YuiAnimEffect.Type.Anim, SHOW_ATTRIBUTE, 1, YuiEasing.easeNone);
    }

    public YuiAnimEffect mouseoutEffect() {
        return new YuiAnim(YuiAnimEffect.Type.Anim, HIDE_ATTRIBUTE, 1, YuiEasing.easeNone);
    }

    public YuiAnimEffect mouseoverEffect() {
        return new YuiAnim(YuiAnimEffect.Type.Anim, SHOW_ATTRIBUTE, 1, YuiEasing.easeNone);
    }

    public abstract Component newOnloadItem(String var1);

    public abstract Component newMouseoverItem(String var1);

    public abstract Component newOnclickItem(String var1);

    public FormComponent getElement() {
        return this.element;
    }

    public void setElement(FormComponent element) {
        this.element = element;
    }

    public String getSelectValue() {
        return this.selectValue;
    }

    public void setSelectValue(String selectValue) {
        this.selectValue = selectValue;
    }

    public String getUnselectValue() {
        return this.unselectValue;
    }

    public void setUnselectValue(String unselectValue) {
        this.unselectValue = unselectValue;
    }

    public YuiAnimation getOnunselectAnimation() {
        return this.onunselectAnimation;
    }

    public void setOnunselectAnimation(YuiAnimation onunselectAnimation) {
        this.onunselectAnimation = onunselectAnimation;
    }

    public Component getMouseoverItem() {
        return this.mouseoverItem;
    }

    public void setMouseoverItem(Component mouseoverItem) {
        this.mouseoverItem = mouseoverItem;
    }
}

