/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animation.thumbnail;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.yui.behavior.animation.YuiAnim;
import org.wicketstuff.yui.behavior.animation.YuiAnimEffect;
import org.wicketstuff.yui.behavior.animation.YuiEasing;
import org.wicketstuff.yui.helper.Attributes;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.markup.html.animation.thumbnail.AnimatedItem;
import org.wicketstuff.yui.markup.html.animation.thumbnail.AnimatedThumbnailSettings;
import org.wicketstuff.yui.markup.html.image.URIImagePanel;

public class AnimatedThumbnail
extends AnimatedItem {
    private AnimatedThumbnailSettings settings;

    public AnimatedThumbnail(String id, FormComponent element, AnimatedThumbnailSettings settings) {
        super(id, element, settings.getSelectValue(), null);
        this.settings = settings;
        this.add(new IBehavior[]{HeaderContributor.forCss(AnimatedThumbnail.class, (String)"AnimatedThumbnail.css")});
        this.init();
    }

    public AnimatedThumbnail(String id, AnimatedThumbnailSettings settings) {
        this(id, null, settings);
    }

    public Component newMouseoverItem(String id) {
        Label mouseover = new Label(id, this.getSettings().getCaptionText());
        mouseover.add(new IBehavior[]{new StyleSizeModifier()});
        return mouseover;
    }

    public YuiAnimEffect mouseoverEffect() {
        Attributes attributes = new Attributes();
        attributes.add(SHOW_ATTRIBUTE);
        attributes.add(new Attributes("opacity", 0.0f, this.getSettings().getOpacity()));
        return new YuiAnim(YuiAnimEffect.Type.Anim, attributes, 0, YuiEasing.easeNone);
    }

    public YuiAnimEffect mouseoutEffect() {
        Attributes attributes = new Attributes();
        attributes.add(HIDE_ATTRIBUTE);
        attributes.add(new Attributes("opacity", this.getSettings().getOpacity(), 0.0f));
        return new YuiAnim(YuiAnimEffect.Type.Anim, attributes, 1, YuiEasing.easeNone);
    }

    public Component newOnclickItem(String id) {
        URIImagePanel onclick = new URIImagePanel(id, this.getSettings().getPictureURI());
        onclick.add(new IBehavior[]{new StyleSizeModifier()});
        return onclick;
    }

    public YuiAnimEffect onselectEffect() {
        Attributes attributes = new Attributes();
        attributes.add(SHOW_ATTRIBUTE);
        attributes.add(new Attributes("width", 0, this.getSettings().getPictureWidth()));
        attributes.add(new Attributes("height", 0, this.getSettings().getPictureHeight()));
        attributes.add(new Attributes("top", 0, this.getSettings().getPictureTop()));
        attributes.add(new Attributes("left", 0, this.getSettings().getPictureLeft()));
        return new YuiAnim(YuiAnimEffect.Type.Anim, attributes, 1, YuiEasing.easeNone);
    }

    public YuiAnimEffect onunselectEffect() {
        Attributes attributes = new Attributes();
        attributes.add(HIDE_ATTRIBUTE);
        attributes.add(new Attributes("width", this.getSettings().getPictureWidth(), 0));
        attributes.add(new Attributes("height", this.getSettings().getPictureHeight(), 0));
        return new YuiAnim(YuiAnimEffect.Type.Anim, attributes, 1, YuiEasing.easeNone);
    }

    public Component newOnloadItem(String id) {
        URIImagePanel onload = new URIImagePanel(id, this.getSettings().getThumbnailURI());
        onload.add(new IBehavior[]{new StyleSizeModifier()});
        return onload;
    }

    public AnimatedThumbnailSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AnimatedThumbnailSettings settings) {
        this.settings = settings;
    }

    private class StyleSizeModifier
    extends AttributeModifier {
        public StyleSizeModifier() {
            super("style", true, (IModel)new AbstractReadOnlyModel(){

                public Object getObject() {
                    CSSInlineStyle style = new CSSInlineStyle();
                    style.add("width", AnimatedThumbnail.this.getSettings().getThumbnailWidth() + "px");
                    style.add("height", AnimatedThumbnail.this.getSettings().getThumbnailHeight() + "px");
                    return style.getStyle();
                }
            });
        }
    }
}

