/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animation.thumbnail;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.GridView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.markup.html.animation.thumbnail.AnimatedThumbnail;
import org.wicketstuff.yui.markup.html.animation.thumbnail.AnimatedThumbnailSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatedThumbnailGallery
extends Panel {
    private static final long serialVersionUID = 1L;
    private IDataProvider dataProvider;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private int pictureWidth;
    private int pictureHeight;

    public AnimatedThumbnailGallery(String id, List<AnimatedThumbnailSettings> listOfThumbnails, int cols, int rows) {
        super(id);
        this.dataProvider = new ThumbnailProvider(listOfThumbnails);
        this.init(this.dataProvider, cols, rows);
    }

    public AnimatedThumbnailGallery(String id, IDataProvider provider, int cols, int rows) {
        super(id);
        this.dataProvider = provider;
        this.init(provider, cols, rows);
    }

    private void init(IDataProvider provider, final int cols, int rows) {
        this.add(new IBehavior[]{HeaderContributor.forCss(AnimatedThumbnailGallery.class, (String)"AnimatedThumbnailGallery.css")});
        Component[] componentArray = new Component[1];
        GridView view = new GridView("rows", this.dataProvider){

            protected void populateEmptyItem(Item item) {
                item.add(new Component[]{new Label("animatedThumbnail", "--")});
            }

            protected void populateItem(Item item) {
                int index = item.getIndex();
                AnimatedThumbnailSettings settings = (AnimatedThumbnailSettings)item.getModelObject();
                settings.setThumbnailDimension(AnimatedThumbnailGallery.this.thumbnailWidth, AnimatedThumbnailGallery.this.thumbnailHeight);
                settings.setPictureDimension(AnimatedThumbnailGallery.this.pictureWidth, AnimatedThumbnailGallery.this.pictureHeight);
                settings.setPicturePosition(AnimatedThumbnailGallery.this.getPositionLeft(index, cols), AnimatedThumbnailGallery.this.getPositionTop(index, cols));
                item.add(new Component[]{new AnimatedThumbnail("animatedThumbnail", settings).add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new Model((Serializable)((Object)("width:" + AnimatedThumbnailGallery.this.thumbnailWidth + ";height:" + AnimatedThumbnailGallery.this.thumbnailHeight + ";"))), "")})});
            }
        };
        componentArray[0] = view;
        this.add(componentArray);
        view.setColumns(cols);
        view.setRows(rows);
    }

    private int getPositionLeft(int index, int cols) {
        int offset_w = index % cols;
        return 0 - offset_w * this.thumbnailWidth + cols * this.thumbnailWidth;
    }

    protected int getPositionTop(int index, int cols) {
        int offset_h = index / cols;
        return 0 - offset_h * this.thumbnailHeight;
    }

    public void setThumbnailSize(int tn_width, int tn_height) {
        this.thumbnailWidth = tn_width;
        this.thumbnailHeight = tn_height;
    }

    public void setPictureSize(int width, int height) {
        this.pictureWidth = width;
        this.pictureHeight = height;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbnailProvider
    implements IDataProvider {
        List<AnimatedThumbnailSettings> listOfThumbnails;

        public ThumbnailProvider(List<AnimatedThumbnailSettings> listOfThumbnails) {
            this.listOfThumbnails = listOfThumbnails;
        }

        public Iterator iterator(int first, int count) {
            return this.listOfThumbnails.iterator();
        }

        public IModel model(Object object) {
            return new Model((Serializable)((AnimatedThumbnailSettings)object));
        }

        public int size() {
            return this.listOfThumbnails.size();
        }

        public void detach() {
        }
    }
}

