/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animselect;

import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectOption;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectSettings;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;

public class AnimSelectOptionGroup
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private List<AnimSelectOption> animSelectOptionList;
    private double duration;
    private String easing;
    private String javaScriptId;
    private int maxSelection;
    private String selectedValues = "";

    public AnimSelectOptionGroup(String id, AnimSelectSettings settings) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        this.animSelectOptionList = settings.getAnimSelectOptionList();
        this.easing = settings.getEasing();
        this.duration = settings.getDuration();
        this.maxSelection = settings.getMaxSelection();
        for (int i = 0; i < this.animSelectOptionList.size(); ++i) {
            AnimSelectOption animSelectOption = this.animSelectOptionList.get(i);
            String value = animSelectOption.getSelectedValue();
            this.selectedValues = this.selectedValues.equals("") ? "'" + value + "'" : this.selectedValues + ",'" + value + "'";
        }
        Label initialization = new Label("init", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return AnimSelectOptionGroup.this.getJavaScriptComponentInitializationScript();
            }
        });
        initialization.setEscapeModelStrings(false);
        this.add(new Component[]{initialization});
    }

    protected String getJavaScriptComponentInitializationScript() {
        PackagedTextTemplate template = new PackagedTextTemplate(AnimSelectOptionGroup.class, "init.js");
        HashMap<String, Object> variables = new HashMap<String, Object>(6);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("easing", "YAHOO.util.Easing." + this.easing);
        variables.put("duration", new Double(this.duration));
        variables.put("maxSelection", new Integer(this.maxSelection));
        variables.put("noOfBoxes", new Integer(this.animSelectOptionList.size()));
        variables.put("selectedValues", this.selectedValues);
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
    }
}

