/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.animselect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.animselect.AnimSelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimSelectSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AnimSelectOption> animSelectOptionList;
    private List<CSSInlineStyle> defaultImgOverStyleList = new ArrayList<CSSInlineStyle>();
    private List<CSSInlineStyle> defaultImgStyleList = new ArrayList<CSSInlineStyle>();
    private double duration;
    private String easing;
    private int height;
    private int maxSelection;
    private String message;
    private List<CSSInlineStyle> selectedImgOverStyleList = new ArrayList<CSSInlineStyle>();
    private List<CSSInlineStyle> selectedImgStyleList = new ArrayList<CSSInlineStyle>();
    private int width;

    public static AnimSelectSettings getDefault(String easing, double duration, int maxSelection, List<AnimSelectOption> animSelectOptionList) {
        AnimSelectSettings settings = new AnimSelectSettings();
        settings.setResources(easing, duration, maxSelection, animSelectOptionList);
        return settings;
    }

    public static AnimSelectSettings getDefault(String easing, double duration, int maxSelection, String message, List<AnimSelectOption> animSelectOptionList) {
        AnimSelectSettings settings = new AnimSelectSettings();
        settings.setResources(easing, duration, maxSelection, message, animSelectOptionList);
        return settings;
    }

    public List<AnimSelectOption> getAnimSelectOptionList() {
        return this.animSelectOptionList;
    }

    public List<CSSInlineStyle> getDefaultImgOverStyleList() {
        return this.defaultImgOverStyleList;
    }

    public List<CSSInlineStyle> getDefaultImgStyleList() {
        return this.defaultImgStyleList;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getEasing() {
        return this.easing;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxSelection() {
        return this.maxSelection;
    }

    public String getMessage() {
        return this.message;
    }

    public List<CSSInlineStyle> getSelectedImgOverStyleList() {
        return this.selectedImgOverStyleList;
    }

    public List<CSSInlineStyle> getSelectedImgStyleList() {
        return this.selectedImgStyleList;
    }

    public int getWidth() {
        return this.width;
    }

    public void setAnimSelectOptionList(List<AnimSelectOption> animSelectOptionList) {
        this.animSelectOptionList = animSelectOptionList;
    }

    public void setDefaultImgOverStyleList(List<CSSInlineStyle> defaultImgOverStyleList) {
        this.defaultImgOverStyleList = defaultImgOverStyleList;
    }

    public void setDefaultImgStyleList(List<CSSInlineStyle> defaultImgStyleList) {
        this.defaultImgStyleList = defaultImgStyleList;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setEasing(String easing) {
        this.easing = easing;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setImageResources(List<AnimSelectOption> animSelectOptionList) {
        for (int i = animSelectOptionList.size() - 1; i >= 0; --i) {
            YuiImage defaultImg = animSelectOptionList.get(i).getDefaultImg();
            YuiImage defaultImgOver = animSelectOptionList.get(i).getDefaultImgOver();
            YuiImage selectedImg = animSelectOptionList.get(i).getSelectedImg();
            YuiImage selectedImgOver = animSelectOptionList.get(i).getSelectedImgOver();
            ResourceReference defaultImgRR = new ResourceReference(AnimSelectSettings.class, defaultImg.getFileName());
            ResourceReference defaultImgOverRR = new ResourceReference(AnimSelectSettings.class, defaultImgOver.getFileName());
            ResourceReference selectedImgRR = new ResourceReference(AnimSelectSettings.class, selectedImg.getFileName());
            ResourceReference selectedImgOverRR = new ResourceReference(AnimSelectSettings.class, selectedImgOver.getFileName());
            ImageResourceInfo defaultImgInfo = new ImageResourceInfo(defaultImgRR);
            int defaultImgWidth = defaultImgInfo.getWidth();
            int defaultImgHeight = defaultImgInfo.getHeight();
            ImageResourceInfo defaultImgOverInfo = new ImageResourceInfo(defaultImgOverRR);
            int defaultImgOverWidth = defaultImgOverInfo.getWidth();
            int defaultImgOverHeight = defaultImgOverInfo.getHeight();
            ImageResourceInfo selectedImgInfo = new ImageResourceInfo(selectedImgRR);
            int selectedImgWidth = selectedImgInfo.getWidth();
            int selectedImgHeight = selectedImgInfo.getHeight();
            ImageResourceInfo selectedImgOverInfo = new ImageResourceInfo(selectedImgOverRR);
            int selectedImgOverWidth = selectedImgOverInfo.getWidth();
            int selectedImgOverHeight = selectedImgOverInfo.getHeight();
            CSSInlineStyle defaultImgStyle = new CSSInlineStyle();
            defaultImgStyle.add("background", "url(" + RequestCycle.get().urlFor(defaultImgRR) + ")");
            defaultImgStyle.add("width", defaultImgWidth + "px");
            defaultImgStyle.add("height", defaultImgHeight + "px");
            CSSInlineStyle defaultImgOverStyle = new CSSInlineStyle();
            defaultImgOverStyle.add("background", "url(" + RequestCycle.get().urlFor(defaultImgOverRR) + ")");
            defaultImgOverStyle.add("width", defaultImgOverWidth + "px");
            defaultImgOverStyle.add("height", defaultImgOverHeight + "px");
            CSSInlineStyle selectedImgStyle = new CSSInlineStyle();
            selectedImgStyle.add("background", "url(" + RequestCycle.get().urlFor(selectedImgRR) + ")");
            selectedImgStyle.add("width", selectedImgWidth + "px");
            selectedImgStyle.add("height", selectedImgHeight + "px");
            CSSInlineStyle selectedImgOverStyle = new CSSInlineStyle();
            selectedImgOverStyle.add("background", "url(" + RequestCycle.get().urlFor(selectedImgOverRR) + ")");
            selectedImgOverStyle.add("width", selectedImgOverWidth + "px");
            selectedImgOverStyle.add("height", selectedImgOverHeight + "px");
            this.defaultImgStyleList.add(defaultImgStyle);
            this.defaultImgOverStyleList.add(defaultImgOverStyle);
            this.selectedImgStyleList.add(selectedImgStyle);
            this.selectedImgOverStyleList.add(selectedImgOverStyle);
            this.width = defaultImgWidth;
            this.height = defaultImgHeight;
        }
    }

    public void setMaxSelection(int maxSelection) {
        this.maxSelection = maxSelection;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResources(String easing, double duration, int maxSelection, List<AnimSelectOption> animSelectOptionList) {
        this.setEasing(easing);
        this.setDuration(duration);
        this.setMaxSelection(maxSelection);
        this.setAnimSelectOptionList(animSelectOptionList);
        this.setImageResources(animSelectOptionList);
    }

    public void setResources(String easing, double duration, int maxSelection, String message, List<AnimSelectOption> animSelectOptionList) {
        this.setEasing(easing);
        this.setDuration(duration);
        this.setMaxSelection(maxSelection);
        this.setMessage(message);
        this.setAnimSelectOptionList(animSelectOptionList);
        this.setImageResources(animSelectOptionList);
    }

    public void setSelectedImgOverStyleList(List<CSSInlineStyle> selectedImgOverStyleList) {
        this.selectedImgOverStyleList = selectedImgOverStyleList;
    }

    public void setSelectedImgStyleList(List<CSSInlineStyle> selectedImgStyleList) {
        this.selectedImgStyleList = selectedImgStyleList;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

