/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.container;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.behavior.resize.YuiResize;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YuiPanel
extends Panel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MODULE_NAME = "wicket_yui_panel";
    private static final ResourceReference MODULE_JS_REF = new ResourceReference(YuiPanel.class, "YuiPanel.js");
    private static final String[] MODULE_REQUIRES = new String[]{"container", "animation", "dragdrop", "utilities"};
    protected WebMarkupContainer container;
    private WebMarkupContainer yuiPanel;
    private AbstractDefaultAjaxBehavior ajaxBehavior;
    private boolean usesOverlayManager;
    private static final String EVENT_TYPE = "type";

    public YuiPanel(String id, IModel<?> model) {
        super(id, model);
        this.init();
    }

    public YuiPanel(String id) {
        super(id);
        this.init();
    }

    public YuiPanel setUsesOverlayManager(boolean usesOverlayManager) {
        this.usesOverlayManager = usesOverlayManager;
        return this;
    }

    private void init() {
        IBehavior[] iBehaviorArray = new IBehavior[1];
        this.ajaxBehavior = new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                String type = RequestCycle.get().getRequest().getParameter(YuiPanel.EVENT_TYPE);
                if (YuiPanel.this.usesOverlayManager) {
                    target.prependJavascript(YuiPanel.this.deregisterPanelJs());
                }
                YuiPanel.this.onHide(target, type);
            }
        };
        iBehaviorArray[0] = this.ajaxBehavior;
        this.add(iBehaviorArray);
        Component[] componentArray = new Component[1];
        this.container = new WebMarkupContainer("yuiPanel_container");
        componentArray[0] = this.container;
        this.add(componentArray);
        this.container.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)this.getCssClass())))});
        Component[] componentArray2 = new Component[1];
        this.yuiPanel = new WebMarkupContainer("yuiPanel");
        componentArray2[0] = this.yuiPanel;
        this.container.add(componentArray2);
        this.yuiPanel.setOutputMarkupId(true);
        this.yuiPanel.add(new IBehavior[]{new YuiResize(){
            private static final long serialVersionUID = 1L;

            protected String getOpts() {
                return YuiPanel.this.getResizeOpts();
            }

            protected String getStartResizeJs() {
                return " function() { var cfg = " + YuiPanel.this.getYuiPanelVar() + ".cfg; " + " if (cfg.getProperty(\"constraintoviewport\")) { " + "   var D = YAHOO.util.Dom;" + "   var clientRegion = D.getClientRegion();" + "   var elRegion = D.getRegion(" + YuiPanel.this.getYuiPanelVar() + ".element);" + "   " + this.getYuiResizeVar() + ".set(\"maxWidth\", clientRegion.right - elRegion.left - YAHOO.widget.Overlay.VIEWPORT_OFFSET);" + "   " + this.getYuiResizeVar() + ".set(\"maxHeight\", clientRegion.bottom - elRegion.top - YAHOO.widget.Overlay.VIEWPORT_OFFSET);" + " } else { " + "   " + this.getYuiResizeVar() + ". set(\"maxWidth\", null); " + "   " + this.getYuiResizeVar() + ".set(\"maxHeight\", null);" + "}" + "} ";
            }

            protected String getResizeJs() {
                return " function(args) { var panelHeight = args.height; " + YuiPanel.this.getYuiPanelVar() + ".cfg.setProperty(\"height\", panelHeight + \"px\");" + "} ";
            }
        }});
        this.yuiPanel.add(new Component[]{this.newHeaderPanel("hd")});
        this.yuiPanel.add(new Component[]{this.newBodyPanel("bd")});
        this.yuiPanel.add(new Component[]{this.newFooterPanel("ft")});
        this.add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_JS_REF, MODULE_REQUIRES){
            private static final long serialVersionUID = 1L;

            public String onSuccessJS() {
                return YuiPanel.this.getInitJS();
            }
        })});
    }

    protected void onHide(AjaxRequestTarget target, String type) {
    }

    protected Component newFooterPanel(String id) {
        return new Label(id, "FOOTER");
    }

    protected Component newBodyPanel(String id) {
        return new Label(id, "BODY");
    }

    protected Component newHeaderPanel(String id) {
        return new Label(id, "HEADER");
    }

    protected String getCssClass() {
        return "yui-skin-sam";
    }

    public String getInitJS() {
        return "var " + this.getYuiPanelVar() + " = new YAHOO.widget.Panel(\"" + this.getYuiPanelId() + "\"," + this.getOpts() + ");" + this.getYuiPanelVar() + ".render();\n" + this.subscribeEventCallback("hide") + (this.usesOverlayManager ? this.registerPanelJs() : "");
    }

    protected String subscribeEventCallback(String jsEvent) {
        return this.getYuiPanelVar() + ".subscribe(\"hide\", function(type, args) { " + "wicketAjaxGet('" + this.ajaxBehavior.getCallbackUrl(true) + "&" + EVENT_TYPE + "='+type);" + " } );\n";
    }

    private String registerPanelJs() {
        return "WicketStuff.Yui.registerPanel('" + this.getYuiPanelId() + "'," + this.getYuiPanelVar() + ");\n";
    }

    private String deregisterPanelJs() {
        return "WicketStuff.Yui.deregisterPanel(" + this.getYuiPanelVar() + ");\n";
    }

    protected String getResizeOpts() {
        return "{ handles : ['br'], proxy: true, status: true, animate: true, animateDuration: .75, animateEasing: YAHOO.util.Easing.backBoth}";
    }

    protected String getOpts() {
        return "{draggable: true, \nwidth: \"500px\", \nheight: \"150px\", \nautofillheight: \"body\", \nconstraintoviewport: true, \ncontext: [\"" + this.container.getMarkupId() + "\", \"tl\", \"bl\"]," + "effect:{effect:YAHOO.widget.ContainerEffect.FADE,duration:0.25}" + " }";
    }

    private String getYuiPanelVar() {
        return "var_" + this.getYuiPanelId();
    }

    private String getYuiPanelId() {
        return this.yuiPanel.getMarkupId();
    }
}

