/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.container;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.yui.markup.html.container.IYuiWindow;
import org.wicketstuff.yui.markup.html.container.YuiPanel;
import org.wicketstuff.yui.markup.html.container.YuiWindowDimension;

public class YuiWindows
extends Panel {
    private static final String OPTS = "{close : true, draggable : true, underlay : 'shadow', modal : false, visible : true, effect : {effect:YAHOO.widget.ContainerEffect.FADE,duration:0.25}, monitorresize : true, constraintoviewport : true, iframe : false, autofillheight :'body', %s }";

    public YuiWindows(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Component[]{new RepeatingView("windows")});
    }

    public String addWindow(final IYuiWindow window) {
        YuiPanel yuiPanel = new YuiPanel(this.getRepeater().newChildId()){

            protected String getOpts() {
                return YuiWindows.this.newOptions(window.getDimension(), window.getAdditionalOpts());
            }

            protected String getResizeOpts() {
                return "{handles : ['br'], proxy: true, status: true, animate: false}";
            }

            protected Component newBodyPanel(String id) {
                return window.newBody(id);
            }

            protected Component newFooterPanel(String id) {
                return window.newFooter(id);
            }

            protected Component newHeaderPanel(String id) {
                return window.newHeader(id);
            }

            protected void onHide(AjaxRequestTarget target, String type) {
                YuiWindows.this.getRepeater().remove((Component)this);
                YuiWindows.this.removeElementFromDom(target, this.getMarkupId());
            }
        };
        yuiPanel.setOutputMarkupId(true);
        yuiPanel.setUsesOverlayManager(true);
        this.getRepeater().add(new Component[]{yuiPanel});
        AjaxRequestTarget target = AjaxRequestTarget.get();
        if (target != null) {
            String createDiv = "(function(){var c=document.createElement('div');c.id='%s';Wicket.$('%s').appendChild(c)})();";
            target.prependJavascript(String.format(createDiv, yuiPanel.getMarkupId(), this.getMarkupId()));
            target.addComponent((Component)yuiPanel);
        }
        return yuiPanel.getId();
    }

    public void removeWindow(String id) {
        String markupId = this.getRepeater().get(id).getMarkupId();
        this.getRepeater().remove(id);
        AjaxRequestTarget target = AjaxRequestTarget.get();
        if (target != null) {
            this.removeElementFromDom(target, markupId);
        }
    }

    private RepeatingView getRepeater() {
        return (RepeatingView)this.get(0);
    }

    private void removeElementFromDom(AjaxRequestTarget target, String yuiPanelMarkupId) {
        target.appendJavascript(String.format("Wicket.$('%s').removeChild(Wicket.$('%s'));", this.getMarkupId(), yuiPanelMarkupId));
    }

    private String newOptions(YuiWindowDimension windowDimension, String otherOpts) {
        return String.format(OPTS, this.newSizeOptions(windowDimension) + (Strings.isEmpty((CharSequence)otherOpts) ? "" : ", " + otherOpts));
    }

    private String newSizeOptions(YuiWindowDimension windowDimension) {
        if (windowDimension == null) {
            throw new NullPointerException("windowDimension must not be null");
        }
        StringBuilder sb = new StringBuilder();
        int[] topLeft = windowDimension.getTopLeft();
        if (topLeft != null) {
            sb.append(" y: '").append(topLeft[0]).append("px', x: '").append(topLeft[1]).append("px', ");
        }
        int[] widthHeight = windowDimension.getWidthHeight();
        sb.append("width: '").append(widthHeight[0]).append("px', height: '").append(widthHeight[1]).append("px'");
        return sb.toString();
    }
}

