/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YuiDependencyResolver
implements Serializable {
    private final Map<String, Set<String>> deps = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(YuiDependencyResolver.class);

    public Set<String> resolveDependencies(String module, String path) {
        if (this.deps.containsKey(module)) {
            return this.deps.get(module);
        }
        LinkedHashSet<String> depmods = new LinkedHashSet<String>();
        this.fetchModuleDependencies(depmods, module, path);
        this.deps.put(module, depmods);
        return depmods;
    }

    public boolean hasCssAsset(String module, String path) {
        String asset = path + "/" + module + "/assets/" + module + ".css";
        URL url = this.getClass().getResource(asset);
        return null != url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchModuleDependencies(Set<String> deps, String module, String path) {
        String baseName = path + "/" + module + "/" + module;
        InputStream is = this.getClass().getResourceAsStream(baseName + ".js");
        if (null == is) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to find " + baseName + ".js" + ". Trying beta...");
            }
            if (null == (is = this.getClass().getResourceAsStream(baseName + "-beta.js"))) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to find " + baseName + "-beta.js" + ". Trying experimental...");
                }
                if (null == (is = this.getClass().getResourceAsStream(baseName + "-experimental.js"))) {
                    if (log.isInfoEnabled()) {
                        log.info("No Module found for " + module);
                    }
                    return;
                }
            }
        }
        BufferedReader buffy = new BufferedReader(new InputStreamReader(is));
        Pattern pattern = Pattern.compile("\\* @requires (.*)");
        String dependencies = "";
        try {
            String line;
            while ((line = buffy.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (log.isInfoEnabled()) {
                    log.info("Found a match with " + line);
                }
                dependencies = matcher.group(1);
                break;
            }
            if (dependencies.contains(",")) {
                String[] splitDeps;
                for (String sdep : splitDeps = dependencies.split(",")) {
                    if (Strings.isEmpty((CharSequence)sdep)) continue;
                    String tdep = sdep.trim();
                    tdep = tdep.toLowerCase();
                    this.fetchModuleDependencies(deps, tdep, path);
                    deps.add(tdep);
                }
            } else if (!Strings.isEmpty((CharSequence)dependencies)) {
                String tdep = dependencies.trim();
                tdep = tdep.toLowerCase();
                this.fetchModuleDependencies(deps, tdep, path);
                deps.add(tdep);
            }
            return;
        }
        catch (IOException e) {
            log.error("error reading " + baseName, (Throwable)e);
            return;
        }
        finally {
            try {
                buffy.close();
            }
            catch (IOException e) {
                log.error("unable to close BufferedReader", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        File[] files;
        Pattern pat = Pattern.compile("\\* @requires (.*)");
        String baseDir = "/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2";
        File dir = new File("/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2");
        FileFilter ff = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().startsWith(".");
            }
        };
        for (File file : files = dir.listFiles(ff)) {
            String dirName = file.getName();
            log.info("checking directory: " + file.getName());
            String script = "/home/jim/src/wicket/wicket-stuff/wicket-contrib-yui/src/main/java/org/wicketstuff/yui/inc/2.2.2/" + dirName + "/" + dirName;
            File scriptFile = new File(script + ".js");
            if (scriptFile.exists()) {
                log.info("Found script file " + scriptFile.getName());
            } else {
                log.info("couldn't find " + scriptFile.getName() + " will try with beta next");
                scriptFile = new File(script + "-beta.js");
                if (scriptFile.exists()) {
                    log.info("Found script file " + scriptFile.getName());
                } else {
                    log.info("couldn't find " + scriptFile.getName() + " will try experimental next");
                    scriptFile = new File(script + "-experimental.js");
                    if (scriptFile.exists()) {
                        log.info("Found script file " + scriptFile.getName());
                    } else {
                        log.info("couldn't find " + scriptFile.getName() + ". Giving up");
                        continue;
                    }
                }
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(scriptFile, "r");
                byte[] bytes = new byte[(int)raf.length()];
                raf.read(bytes);
                String contents = new String(bytes);
                Matcher match = pat.matcher(contents);
                if (match.find()) {
                    log.info("We have a match in " + scriptFile + ": " + match.group(1));
                    log.info("Starting at " + match.start() + " ending at " + match.end());
                    continue;
                }
                log.info("no match for pattern in " + scriptFile);
            }
            catch (FileNotFoundException e) {
                log.error("Not found", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Can't open", (Throwable)e);
            }
        }
    }
}

