/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor.yuiloader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.wicketstuff.yui.helper.JSArray;
import org.wicketstuff.yui.inc.YUI;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.IYuiLoaderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class YuiLoader
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static String BUILD = "2.7.0b";
    protected static String DEBUG = "'debug'";
    private static final ResourceReference YUILOADER = new ResourceReference(YUI.class, BUILD + "/yuiloader/yuiloader.js");
    protected static final ResourceReference BASE = new ResourceReference(YUI.class, BUILD + "/");
    private List<IYuiLoaderModule> modules = new ArrayList<IYuiLoaderModule>();
    protected boolean rendered = false;

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(YUILOADER);
    }

    protected String getRequireModule() {
        JSArray requires = new JSArray();
        for (IYuiLoaderModule m : this.uniqueModuleNameIter()) {
            requires.add("'" + m.getName() + "'");
        }
        return requires.toString();
    }

    protected String getAddModuleJS(String loader) {
        StringBuffer bufy = new StringBuffer();
        for (IYuiLoaderModule m : this.uniqueModuleNameIter()) {
            bufy.append("\n").append(loader + ".addModule(" + m.getModuleJS() + ");");
        }
        return bufy.toString();
    }

    protected String allOnSuccessJS() {
        StringBuffer bufy = new StringBuffer();
        for (IYuiLoaderModule m : this.getModules()) {
            bufy.append("\n").append(m.onSuccessJS());
        }
        return bufy.toString();
    }

    private Iterable<IYuiLoaderModule> uniqueModuleNameIter() {
        HashSet<IYuiLoaderModule> set = new HashSet<IYuiLoaderModule>();
        for (IYuiLoaderModule m : this.getModules()) {
            set.add(m);
        }
        return set;
    }

    protected static String getBase() {
        return ((Object)RequestCycle.get().urlFor(BASE)).toString();
    }

    public List<IYuiLoaderModule> getModules() {
        return this.modules;
    }

    public void setModules(List<IYuiLoaderModule> modules) {
        this.modules = modules;
    }

    public void add(IYuiLoaderModule module) {
        this.getModules().add(module);
    }

    protected abstract YuiLoader newLoader();
}

