/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor.yuiloader;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.IYuiLoaderModule;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoader;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderInsert;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderSandbox;

public class YuiLoaderContributor
extends AbstractHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static ThreadLocalYuiLoaderContributor threadLocalLoader = new ThreadLocalYuiLoaderContributor();
    private YuiLoader yuiLoader = new YuiLoaderInsert();
    private YuiLoader yuiLoaderSandbox = new YuiLoaderSandbox();

    private YuiLoaderContributor() {
    }

    public static IBehavior addModule(IYuiLoaderModule yuiLoaderModule) {
        return YuiLoaderContributor.addModule(yuiLoaderModule, false);
    }

    public static IBehavior addModule(IYuiLoaderModule module, boolean useSandbox) {
        YuiLoaderContributor loader = YuiLoaderContributor.getCurrentLoader();
        if (useSandbox) {
            loader.yuiLoaderSandbox = YuiLoaderContributor.addModule(loader.yuiLoaderSandbox, module);
        } else {
            loader.yuiLoader = YuiLoaderContributor.addModule(loader.yuiLoader, module);
        }
        return loader;
    }

    private static YuiLoader addModule(YuiLoader loader, IYuiLoaderModule module) {
        if (loader.rendered) {
            loader = loader.newLoader();
        }
        loader.add(module);
        return loader;
    }

    private static YuiLoaderContributor getCurrentLoader() {
        YuiLoaderContributor loader = (YuiLoaderContributor)((Object)threadLocalLoader.get());
        return loader;
    }

    public void detach(Component component) {
        threadLocalLoader.remove();
    }

    public IHeaderContributor[] getHeaderContributors() {
        ArrayList<YuiLoader> contributors = new ArrayList<YuiLoader>();
        if (this.yuiLoader != null && !this.yuiLoader.getModules().isEmpty()) {
            contributors.add(this.yuiLoader);
        }
        if (this.yuiLoaderSandbox != null && !this.yuiLoaderSandbox.getModules().isEmpty()) {
            contributors.add(this.yuiLoaderSandbox);
        }
        return contributors.toArray(new IHeaderContributor[contributors.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalYuiLoaderContributor
    extends ThreadLocal<YuiLoaderContributor> {
        private ThreadLocalYuiLoaderContributor() {
        }

        @Override
        protected YuiLoaderContributor initialValue() {
            return new YuiLoaderContributor();
        }
    }
}

