/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.cropp;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.io.IOUtils;
import org.wicketstuff.yui.inc.YUI;
import org.wicketstuff.yui.markup.html.cropp.ImageCropper;
import org.wicketstuff.yui.markup.html.cropp.YuiImageCropperSettings;

public abstract class CropImagePanel
extends Panel
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer refresableContainer;
    private YuiImageCropperSettings settings;
    private int prevImgWidth;
    private int prevImgHeight;
    private String fileName;
    private String mimeType;
    private static final JavascriptResourceReference JS_YAHOO = new JavascriptResourceReference(YUI.class, "2.8.1/yahoo/yahoo-min.js");
    private static final JavascriptResourceReference JS_EVENT = new JavascriptResourceReference(YUI.class, "2.8.1/event/event-min.js");
    private static final JavascriptResourceReference JS_DOM = new JavascriptResourceReference(YUI.class, "2.8.1/dom/dom-min.js");
    private static final JavascriptResourceReference JS_DRAGDROP = new JavascriptResourceReference(YUI.class, "2.8.1/dragdrop/dragdrop-min.js");
    private static final JavascriptResourceReference JS_ELEMENT = new JavascriptResourceReference(YUI.class, "2.8.1/element/element-min.js");
    private static final JavascriptResourceReference JS_RESIZE = new JavascriptResourceReference(YUI.class, "2.8.1/resize/resize-min.js");
    private static final JavascriptResourceReference JS_IMAGECROPPER = new JavascriptResourceReference(YUI.class, "2.8.1/imagecropper/imagecropper-min.js");
    private static final CompressedResourceReference CSS_RESIZE = new CompressedResourceReference(YUI.class, "2.8.1/assets/skins/sam/resize.css");
    private static final CompressedResourceReference CSS_IMAGECROPPER = new CompressedResourceReference(YUI.class, "2.8.1/assets/skins/sam/imagecropper.css");

    public CropImagePanel(String id, int prevImgWidth, int prevImgHeight, YuiImageCropperSettings cropperSettings) {
        super(id);
        this.settings = cropperSettings;
        this.prevImgWidth = prevImgWidth;
        this.prevImgHeight = prevImgHeight;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.removeAll();
        this.refresableContainer = new WebMarkupContainer("wmc");
        this.add(new Component[]{this.refresableContainer.setOutputMarkupId(true)});
        this.refresableContainer.add(new Component[]{new Upload("panel", (MarkupContainer)this)});
    }

    protected abstract void onCropImage(InputStream var1, String var2, String var3, AjaxRequestTarget var4);

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected abstract InputStream createThumbnail(InputStream var1, int var2, int var3, boolean var4);

    protected abstract InputStream createCrop(FileInputStream var1, Rectangle var2);

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(WicketEventReference.INSTANCE);
        response.renderJavascriptReference(WicketAjaxReference.INSTANCE);
        if (this.includeYUILibraries()) {
            response.renderJavascriptReference((ResourceReference)JS_YAHOO);
            response.renderJavascriptReference((ResourceReference)JS_DOM);
            response.renderJavascriptReference((ResourceReference)JS_EVENT);
            response.renderJavascriptReference((ResourceReference)JS_DRAGDROP);
            response.renderJavascriptReference((ResourceReference)JS_ELEMENT);
            response.renderJavascriptReference((ResourceReference)JS_RESIZE);
            response.renderJavascriptReference((ResourceReference)JS_IMAGECROPPER);
            response.renderCSSReference((ResourceReference)CSS_RESIZE);
            response.renderCSSReference((ResourceReference)CSS_IMAGECROPPER);
        }
    }

    protected boolean includeYUILibraries() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UploadForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public UploadForm(String id) {
            super(id);
            this.setMultiPart(true);
            FeedbackPanel feedbackPanel = new FeedbackPanel("feedback");
            feedbackPanel.setOutputMarkupId(true);
            this.add(new Component[]{feedbackPanel});
            FileUploadField fileUploadField = new FileUploadField("fileUploadField");
            fileUploadField.setRequired(true);
            this.add(new Component[]{fileUploadField});
            Model resultSizeModel = new Model((Serializable)Integer.valueOf(CropImagePanel.this.settings.getResultImageWidth()));
            TextField<Integer> resultSize = new TextField<Integer>("resultSize", (IModel)resultSizeModel, Integer.class){
                private static final long serialVersionUID = 1L;

                public boolean isEnabled() {
                    return !CropImagePanel.this.settings.isResultImageSizeNoChange() && CropImagePanel.this.settings.isResultImageSizeEditable();
                }
            };
            resultSize.setOutputMarkupId(true);
            this.add(new Component[]{resultSize.setRequired(true)});
            this.add(new Component[]{new AjaxCheckBox("resultImageSizeNoChange", (IModel)new Model((Serializable)Boolean.valueOf(CropImagePanel.this.settings.isResultImageSizeNoChange())), (TextField)resultSize){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ TextField val$resultSize;
                {
                    this.val$resultSize = textField;
                    super(x0, x1);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    CropImagePanel.this.settings.setResultImageSizeNoChange(!CropImagePanel.this.settings.isResultImageSizeNoChange());
                    target.addComponent((Component)this.val$resultSize);
                }

                public boolean isEnabled() {
                    return CropImagePanel.this.settings.isResultImageSizeEditable();
                }
            }});
            this.add(new Component[]{new AjaxSubmitLink("submit", (IModel)resultSizeModel, fileUploadField, feedbackPanel){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ IModel val$resultSizeModel;
                final /* synthetic */ FileUploadField val$fileUploadField;
                final /* synthetic */ FeedbackPanel val$feedbackPanel;
                {
                    this.val$resultSizeModel = iModel;
                    this.val$fileUploadField = fileUploadField;
                    this.val$feedbackPanel = feedbackPanel;
                    super(x0);
                }

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        CropImagePanel.this.settings.setResultImageWidth((Integer)this.val$resultSizeModel.getObject());
                        CropImagePanel.this.settings.setResultImageHeight((Integer)this.val$resultSizeModel.getObject());
                        FileUpload fileUpload = this.val$fileUploadField.getFileUpload();
                        CropImagePanel.this.fileName = fileUpload.getClientFileName();
                        CropImagePanel.this.mimeType = fileUpload.getContentType();
                        InputStream inputStream = CropImagePanel.this.createThumbnail(fileUpload.getInputStream(), CropImagePanel.this.prevImgWidth, CropImagePanel.this.prevImgHeight, false);
                        File file = File.createTempFile(UUID.randomUUID().toString(), null);
                        Files.writeTo((File)file, (InputStream)inputStream);
                        UploadForm.this.onUploaded(file, target);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent((Component)this.val$feedbackPanel);
                }
            }});
            this.add(new Component[]{new AjaxLink<Void>("cancel"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    CropImagePanel.this.onCancel(target);
                }
            }});
        }

        protected void onUploaded(File file, AjaxRequestTarget target) {
        }
    }

    private class Crop
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public Crop(String id, MarkupContainer markupProvider, final File file) {
            super(id, "crop", markupProvider);
            this.setOutputMarkupId(true);
            NonCachingImage image = new NonCachingImage("img", (Resource)new DynamicImageResource(){
                private static final long serialVersionUID = 1L;

                protected byte[] getImageData() {
                    try {
                        return IOUtils.toByteArray((InputStream)new FileInputStream(file));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            image.setOutputMarkupId(true);
            this.add(new Component[]{image});
            ImageCropper imageCropper = new ImageCropper("cropperImage", (IModel)new Model((Serializable)((Object)image.getMarkupId())), CropImagePanel.this.settings){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onCrop(int top, int left, int height, int width, AjaxRequestTarget target) {
                    Rectangle rectangle = new Rectangle(left, top, height, width);
                    try {
                        try {
                            InputStream is;
                            InputStream is2 = is = CropImagePanel.this.createCrop(new FileInputStream(file), rectangle);
                            if (!CropImagePanel.this.settings.isResultImageSizeNoChange()) {
                                is2 = CropImagePanel.this.createThumbnail(is, CropImagePanel.this.settings.getResultImageWidth(), CropImagePanel.this.settings.getResultImageHeight(), CropImagePanel.this.settings.isRatio());
                            }
                            CropImagePanel.this.onCropImage(is2, CropImagePanel.this.fileName, CropImagePanel.this.mimeType, target);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        Files.remove((File)file);
                    }
                }

                protected void onCancel(AjaxRequestTarget target) {
                    CropImagePanel.this.onCancel(target);
                }
            };
            this.add(new Component[]{imageCropper});
        }
    }

    private class Upload
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public Upload(final String id, final MarkupContainer markupProvider) {
            super(id, "upload", markupProvider);
            this.setOutputMarkupId(true);
            UploadForm uploadForm = new UploadForm("form"){
                private static final long serialVersionUID = 1L;

                protected void onUploaded(File file, AjaxRequestTarget target) {
                    Upload.this.replaceWith((Component)new Crop(id, markupProvider, file));
                    target.addComponent((Component)CropImagePanel.this.refresableContainer);
                }
            };
            this.add(new Component[]{uploadForm});
        }
    }
}

