/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.cropp;

import org.apache.wicket.Component;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.wicketstuff.yui.markup.html.cropp.YuiImageCropperSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageCropper
extends Panel {
    private static final long serialVersionUID = 1L;
    private final CallbackBehavior callbackBehavior;

    public ImageCropper(String id, IModel<String> model, final YuiImageCropperSettings settings) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onRendered(Component component) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("top = " + settings.getTop() + ";");
                buffer.append("left = " + settings.getLeft() + ";");
                buffer.append("height = " + settings.getHeight() + ";");
                buffer.append("width = " + settings.getWidth() + ";");
                buffer.append("var " + ImageCropper.this.getCropperVar() + " = new YAHOO.widget.ImageCropper('" + ImageCropper.this.getImageId() + "', {");
                buffer.append("initialXY: [left,top],");
                buffer.append("keyTick: " + settings.getKeyTick() + ",");
                buffer.append("shiftKeyTick: " + settings.getShiftKeyTick() + ",");
                buffer.append("minHeight: " + settings.getMinHeight() + ",");
                buffer.append("minWidth: " + settings.getMinWidth() + ",");
                buffer.append("ratio: " + settings.isRatio() + ",");
                buffer.append("initHeight: height,");
                buffer.append("initWidth: width");
                buffer.append("});");
                buffer.append(ImageCropper.this.getCropperVar() + ".on('moveEvent', function() {");
                buffer.append("var region = " + ImageCropper.this.getCropperVar() + ".getCropCoords();");
                buffer.append("top = region.top;");
                buffer.append("left = region.left;");
                buffer.append("height = region.height;");
                buffer.append("width = region.width;");
                buffer.append("});");
                Response response = component.getResponse();
                response.write((CharSequence)"<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
                response.write((CharSequence)("YAHOO.util.Event.onContentReady('" + ImageCropper.this.getImageId() + "',function() {" + buffer.toString() + "});"));
                response.write((CharSequence)"\n/*-->]]>*/</script>\n");
            }
        }});
        IBehavior[] iBehaviorArray = new IBehavior[1];
        this.callbackBehavior = new CallbackBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onCropInternal(int top, int left, int height, int width, AjaxRequestTarget target) {
                ImageCropper.this.onCrop(top, left, height, width, target);
            }
        };
        iBehaviorArray[0] = this.callbackBehavior;
        this.add(iBehaviorArray);
        this.add(new Component[]{this.newLinkComponent("link").add(new Component[]{this.newLabelComponent("linkLabel")})});
        this.add(new Component[]{new AjaxLink<Void>("cancel"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ImageCropper.this.onCancel(target);
            }
        }});
    }

    protected IModel<String> getLinkLabelModel() {
        return new ResourceModel("apply");
    }

    protected Component newLabelComponent(String id) {
        return new Label(id, this.getLinkLabelModel());
    }

    protected WebMarkupContainer newLinkComponent(String id) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                target.prependJavascript("" + ImageCropper.this.callbackBehavior.getEventHandler());
            }
        };
    }

    protected abstract void onCrop(int var1, int var2, int var3, int var4, AjaxRequestTarget var5);

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected String getCropperVar() {
        return "var_" + this.getMarkupId();
    }

    protected String getImageId() {
        return this.getDefaultModelObjectAsString();
    }

    private static abstract class CallbackBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public CallbackBehavior() {
            super("callbackBehavior");
        }

        protected void onComponentTag(ComponentTag tag) {
        }

        public CharSequence getEventHandler() {
            return super.getEventHandler();
        }

        protected CharSequence generateCallbackScript(CharSequence partialCall) {
            CharSequence script = super.generateCallbackScript((CharSequence)("wicketAjaxGet('" + this.getCallbackUrl(false) + "&top='+top+'&left='+left+'&height='+height+'&width='+width"));
            return script;
        }

        protected final void onEvent(AjaxRequestTarget target) {
            String top = this.getComponent().getRequest().getParameter("top");
            String left = this.getComponent().getRequest().getParameter("left");
            String height = this.getComponent().getRequest().getParameter("height");
            String width = this.getComponent().getRequest().getParameter("width");
            this.onCropInternal(Integer.parseInt(top), Integer.parseInt(left), Integer.parseInt(height), Integer.parseInt(width), target);
        }

        protected abstract void onCropInternal(int var1, int var2, int var3, int var4, AjaxRequestTarget var5);
    }
}

