/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dialog;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.template.TextTemplateHeaderContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.dialog.DialogSettings;

public abstract class Dialog
extends Panel
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference CSS = new ResourceReference(Dialog.class, "css/Dialog.css");
    private DialogSettings settings;
    private String javaScriptId;
    private static final Logger log = LoggerFactory.getLogger(Dialog.class);

    public Dialog(String id, IModel model, DialogSettings settings) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new Model((Serializable)((Object)"display:none")), ";")});
        this.settings = settings;
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("event")});
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("animation")});
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("dragdrop")});
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("container")});
        this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)this.getCSS())});
        AbstractReadOnlyModel variablesModel = new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;
            private Map<String, Object> variables;

            public Object getObject() {
                if (this.variables == null) {
                    this.variables = new HashMap<String, Object>(8);
                    this.variables.put("javaScriptId", Dialog.this.javaScriptId);
                    this.variables.put("domId", Dialog.this.getMarkupId());
                    String settings = "{}";
                    if (Dialog.this.settings != null) {
                        settings = Dialog.this.settings.generateSettings();
                    }
                    this.variables.put("settings", settings);
                }
                return this.variables;
            }
        };
        this.add(new IBehavior[]{TextTemplateHeaderContributor.forJavaScript(Dialog.class, (String)"init.js", (IModel)variablesModel)});
        Model labelModel = new Model((Serializable)((Object)""));
        if (this.getTitle() != null) {
            labelModel = this.getTitle();
        }
        this.add(new Component[]{new Label("title", (IModel)labelModel)});
        this.add(new Component[]{this.createContent("content")});
        this.add(new Component[]{this.createFooter("footer")});
    }

    public Model getTitle() {
        return null;
    }

    public abstract Panel createContent(String var1);

    public Panel createFooter(String panelId) {
        return new EmptyPanel(panelId);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderOnLoadJavascript("init" + this.javaScriptId + "();");
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        String id = this.getMarkupId();
        this.javaScriptId = id + "Dialog";
    }

    public ResourceReference getCSS() {
        return CSS;
    }

    public void show(AjaxRequestTarget target) {
        target.appendJavascript(this.javaScriptId + ".show()");
    }

    public void hide(AjaxRequestTarget target) {
        target.appendJavascript(this.javaScriptId + ".hide()");
    }
}

