/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dragdrop;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.template.TextTemplateHeaderContributor;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropDragableSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropPlayer;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropSettings;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropTargetSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlotList;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlot;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlotList;

public class DragDropGroup
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private DragableSlotList dragableSlotList;
    private TargetSlotList targetSlotList;
    private String javaScriptId;

    public DragDropGroup(String id, final DragDropSettings settings, final FormComponent dragableElement, final FormComponent targetElement) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("dragdrop")});
        this.dragableSlotList = settings.getDragableSlotList();
        this.targetSlotList = settings.getTargetSlotList();
        if (dragableElement != null) {
            dragableElement.add(new IBehavior[]{new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return dragableElement.getId() + "_" + DragDropGroup.this.javaScriptId;
                }
            })});
        }
        this.add(new Component[]{dragableElement});
        if (targetElement != null) {
            targetElement.add(new IBehavior[]{new AttributeModifier("id", true, (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    return targetElement.getId() + "_" + DragDropGroup.this.javaScriptId;
                }
            })});
        }
        this.add(new Component[]{targetElement});
        ListView targetSlotView = new ListView(this.targetSlotList.getId(), this.targetSlotList.getTargetList()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem item) {
                TargetSlot targetSlot = (TargetSlot)item.getModelObject();
                YuiImage slot = targetSlot.getSlot();
                item.add(new Component[]{new DragDropTargetSlot(DragDropGroup.this.targetSlotList.getSlotId(), item.getIndex(), slot, settings)});
            }
        };
        this.add(new Component[]{targetSlotView});
        ListView dragableSlotView = new ListView(this.dragableSlotList.getId(), this.dragableSlotList.getDragableList()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem item) {
                DragableSlot dragableSlot = (DragableSlot)item.getModelObject();
                YuiImage slot = dragableSlot.getSlot();
                YuiImage img = dragableSlot.getImage();
                item.add(new Component[]{new DragDropDragableSlot(DragDropGroup.this.dragableSlotList.getSlotId(), item.getIndex(), slot, settings)});
                item.add(new Component[]{new DragDropPlayer(DragDropGroup.this.dragableSlotList.getImgId(), item.getIndex(), img, settings)});
            }
        };
        this.add(new Component[]{dragableSlotView});
    }

    protected Map getJavaScriptComponentInitializationVariables() {
        String targetSlot = "";
        for (int i = 0; i < this.targetSlotList.getSize(); ++i) {
            targetSlot = targetSlot.equals("") || targetSlot == "" ? "'empty'" : targetSlot + ", 'empty'";
        }
        String targetSlotId = "";
        for (int i = 0; i < this.targetSlotList.getSize(); ++i) {
            TargetSlot target = this.targetSlotList.getTargetSlot(i);
            targetSlotId = targetSlotId.equals("") || targetSlotId == "" ? "'" + target.getSlot().getDesc() + "'" : targetSlotId + ", '" + target.getSlot().getDesc() + "'";
        }
        String dragSlot = "";
        for (int i = 0; i < this.dragableSlotList.getSize(); ++i) {
            DragableSlot dragable = this.dragableSlotList.getDragableSlot(i);
            dragSlot = dragSlot.equals("") || dragSlot == "" ? "'" + dragable.getImage().getDesc() + "'" : dragSlot + ", '" + dragable.getImage().getDesc() + "'";
        }
        String dragSlotId = "";
        for (int i = 0; i < this.dragableSlotList.getSize(); ++i) {
            DragableSlot dragable = this.dragableSlotList.getDragableSlot(i);
            dragSlotId = dragSlotId.equals("") || dragSlotId == "" ? "'" + dragable.getSlot().getDesc() + "'" : dragSlotId + ", '" + dragable.getSlot().getDesc() + "'";
        }
        HashMap<String, String> variables = new HashMap<String, String>(5);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("targetSlot", targetSlot);
        variables.put("targetSlotId", targetSlotId);
        variables.put("dragSlot", dragSlot);
        variables.put("dragSlotId", dragSlotId);
        return variables;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = this.getMarkupId();
        PackagedTextTemplate template = new PackagedTextTemplate(DragDropGroup.class, "init.js");
        this.add(new IBehavior[]{TextTemplateHeaderContributor.forJavaScript((TextTemplate)template, (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return DragDropGroup.this.getJavaScriptComponentInitializationVariables();
            }
        })});
    }
}

