/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dragdrop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.helper.ImageResourceInfo;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlot;
import org.wicketstuff.yui.markup.html.dragdrop.DragableSlotList;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlot;
import org.wicketstuff.yui.markup.html.dragdrop.TargetSlotList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragDropSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DragableSlotList dragableSlotList;
    private TargetSlotList targetSlotList;
    private List<CSSInlineStyle> dragableImgStyleList = new ArrayList<CSSInlineStyle>();
    private int dragableImgWidth;
    private int dragableImgHeight;
    private List<CSSInlineStyle> targetSlotStyleList = new ArrayList<CSSInlineStyle>();
    private int targetSlotWidth;
    private int targetSlotHeight;
    private List<CSSInlineStyle> dragableSlotStyleList = new ArrayList<CSSInlineStyle>();
    private int dragableSlotWidth;
    private int dragableSlotHeight;

    public static DragDropSettings getDefault(DragableSlotList dragableSlotList, TargetSlotList targetSlotList) {
        DragDropSettings settings = new DragDropSettings();
        settings.setResources(dragableSlotList, targetSlotList);
        return settings;
    }

    public void setResources(DragableSlotList dragableSlotList, TargetSlotList targetSlotList) {
        this.setDragableSlotList(dragableSlotList);
        this.setTargetSlotList(targetSlotList);
        this.setDragableImageResources(dragableSlotList);
        this.setDragableSlotResources(dragableSlotList);
        this.setTargetSlotResources(targetSlotList);
    }

    public void setDragableImageResources(DragableSlotList dragableSlotList) {
        for (int i = 0; i < dragableSlotList.getSize(); ++i) {
            DragableSlot slot = dragableSlotList.getDragableSlot(i);
            YuiImage img = slot.getImage();
            ResourceReference imgRR = new ResourceReference(DragDropSettings.class, img.getFileName());
            ImageResourceInfo imgInfo = new ImageResourceInfo(imgRR);
            int imgWidth = imgInfo.getWidth();
            int imgHeight = imgInfo.getHeight();
            CSSInlineStyle imgStyle = new CSSInlineStyle();
            imgStyle.add("background", "url(" + RequestCycle.get().urlFor(imgRR) + ")");
            imgStyle.add("width", imgWidth + "px");
            imgStyle.add("height", imgHeight + "px");
            imgStyle.add("top", img.getTop() + "px");
            imgStyle.add("left", img.getLeft() + "px");
            this.dragableImgStyleList.add(imgStyle);
            this.dragableImgWidth = imgWidth;
            this.dragableImgHeight = imgHeight;
        }
    }

    public void setDragableSlotResources(DragableSlotList dragableSlotList) {
        for (int i = 0; i < dragableSlotList.getSize(); ++i) {
            DragableSlot slot = dragableSlotList.getDragableSlot(i);
            YuiImage img = slot.getSlot();
            ResourceReference imgRR = new ResourceReference(DragDropSettings.class, img.getFileName());
            ImageResourceInfo imgInfo = new ImageResourceInfo(imgRR);
            int imgWidth = imgInfo.getWidth();
            int imgHeight = imgInfo.getHeight();
            CSSInlineStyle imgStyle = new CSSInlineStyle();
            imgStyle.add("background", "url(" + RequestCycle.get().urlFor(imgRR) + ")");
            imgStyle.add("width", imgWidth + "px");
            imgStyle.add("height", imgHeight + "px");
            imgStyle.add("top", img.getTop() + "px");
            imgStyle.add("left", img.getLeft() + "px");
            this.dragableSlotStyleList.add(imgStyle);
            this.dragableSlotWidth = imgWidth;
            this.dragableSlotHeight = imgHeight;
        }
    }

    public void setTargetSlotResources(TargetSlotList targetSlotList) {
        for (int i = 0; i < targetSlotList.getSize(); ++i) {
            TargetSlot slot = targetSlotList.getTargetSlot(i);
            YuiImage img = slot.getSlot();
            ResourceReference imgRR = new ResourceReference(DragDropSettings.class, img.getFileName());
            ImageResourceInfo imgInfo = new ImageResourceInfo(imgRR);
            int imgWidth = imgInfo.getWidth();
            int imgHeight = imgInfo.getHeight();
            CSSInlineStyle imgStyle = new CSSInlineStyle();
            imgStyle.add("background", "url(" + RequestCycle.get().urlFor(imgRR) + ")");
            imgStyle.add("width", imgWidth + "px");
            imgStyle.add("height", imgHeight + "px");
            imgStyle.add("top", img.getTop() + "px");
            imgStyle.add("left", img.getLeft() + "px");
            this.targetSlotStyleList.add(imgStyle);
            this.targetSlotWidth = imgWidth;
            this.targetSlotHeight = imgHeight;
        }
    }

    public int getDragableImgHeight() {
        return this.dragableImgHeight;
    }

    public void setDragableImgHeight(int dragableImgHeight) {
        this.dragableImgHeight = dragableImgHeight;
    }

    public List<CSSInlineStyle> getDragableImgStyleList() {
        return this.dragableImgStyleList;
    }

    public void setDragableImgStyleList(List<CSSInlineStyle> dragableImgStyleList) {
        this.dragableImgStyleList = dragableImgStyleList;
    }

    public int getDragableImgWidth() {
        return this.dragableImgWidth;
    }

    public void setDragableImgWidth(int dragableImgWidth) {
        this.dragableImgWidth = dragableImgWidth;
    }

    public int getDragableSlotHeight() {
        return this.dragableSlotHeight;
    }

    public void setDragableSlotHeight(int dragableSlotHeight) {
        this.dragableSlotHeight = dragableSlotHeight;
    }

    public DragableSlotList getDragableSlotList() {
        return this.dragableSlotList;
    }

    public void setDragableSlotList(DragableSlotList dragableSlotList) {
        this.dragableSlotList = dragableSlotList;
    }

    public List<CSSInlineStyle> getDragableSlotStyleList() {
        return this.dragableSlotStyleList;
    }

    public void setDragableSlotStyleList(List<CSSInlineStyle> dragableSlotStyleList) {
        this.dragableSlotStyleList = dragableSlotStyleList;
    }

    public int getDragableSlotWidth() {
        return this.dragableSlotWidth;
    }

    public void setDragableSlotWidth(int dragableSlotWidth) {
        this.dragableSlotWidth = dragableSlotWidth;
    }

    public int getTargetSlotHeight() {
        return this.targetSlotHeight;
    }

    public void setTargetSlotHeight(int targetSlotHeight) {
        this.targetSlotHeight = targetSlotHeight;
    }

    public TargetSlotList getTargetSlotList() {
        return this.targetSlotList;
    }

    public void setTargetSlotList(TargetSlotList targetSlotList) {
        this.targetSlotList = targetSlotList;
    }

    public List<CSSInlineStyle> getTargetSlotStyleList() {
        return this.targetSlotStyleList;
    }

    public void setTargetSlotStyleList(List<CSSInlineStyle> targetSlotStyleList) {
        this.targetSlotStyleList = targetSlotStyleList;
    }

    public int getTargetSlotWidth() {
        return this.targetSlotWidth;
    }

    public void setTargetSlotWidth(int targetSlotWidth) {
        this.targetSlotWidth = targetSlotWidth;
    }
}

