/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.dragdrop;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.wicketstuff.yui.helper.YuiImage;
import org.wicketstuff.yui.markup.html.contributor.YuiHeaderContributor;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropGroup;
import org.wicketstuff.yui.markup.html.dragdrop.DragDropSettings;

public class DragDropTargetSlot
extends Panel {
    private static final long serialVersionUID = 1L;
    private int index;
    private YuiImage slot;
    private DragDropSettings settings;
    private String javaScriptId;

    public DragDropTargetSlot(final String id, final int index, YuiImage slot, DragDropSettings settings) {
        super(id);
        this.add(new IBehavior[]{YuiHeaderContributor.forModule("dragdrop")});
        this.index = index;
        this.slot = slot;
        this.settings = settings;
        Label slotLabel = new Label("dragDropTargetScript", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return DragDropTargetSlot.this.getDragDropSlotInitializationScript(id + "" + index);
            }
        });
        slotLabel.setEscapeModelStrings(false);
        this.add(new Component[]{slotLabel});
    }

    public int getIndex() {
        return this.index;
    }

    public DragDropSettings getSettings() {
        return this.settings;
    }

    public YuiImage getSlot() {
        return this.slot;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setSettings(DragDropSettings settings) {
        this.settings = settings;
    }

    public void setSlot(YuiImage slot) {
        this.slot = slot;
    }

    protected String getDragDropSlotInitializationScript(String slotId) {
        PackagedTextTemplate template = new PackagedTextTemplate(DragDropTargetSlot.class, "dragdropSlot.js");
        HashMap<String, String> variables = new HashMap<String, String>(3);
        variables.put("javaScriptId", this.javaScriptId);
        variables.put("id", slotId);
        variables.put("dragableSlot", this.settings.getTargetSlotList().getId());
        template.interpolate(variables);
        return template.getString();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.javaScriptId = ((DragDropGroup)((Object)this.findParent(DragDropGroup.class))).getMarkupId();
    }
}

