/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.ellipse;

import java.io.Serializable;

public class EllipseHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double width = 0.0;
    private double height = 0.0;
    private int segments = 1;
    private float theta;

    public EllipseHelper(double width, double height, int segments) {
        this.width = width;
        this.height = height;
        this.segments = segments;
        this.theta = 360 / segments;
    }

    public EllipseHelper(int segments) {
        this.segments = segments;
        this.theta = 360 / segments;
    }

    public double getX(int segment) {
        return this.getWidth() / 2.0 * Math.cos(this.getRadians(segment));
    }

    public double getY(int segment) {
        return this.getHeight() / 2.0 * Math.sin(this.getRadians(segment));
    }

    private double getRadians(int segment) {
        float t = this.getTheta() * (float)segment - 90.0f;
        return Math.toRadians(t);
    }

    public int getLeft(int segment) {
        return (int)(this.getWidth() / 2.0 + this.getX(segment));
    }

    public int getTop(int segment) {
        return (int)(this.getHeight() / 2.0 + this.getY(segment));
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public int getSegments() {
        return this.segments;
    }

    public void setSegments(int segments) {
        this.segments = segments;
    }

    public float getTheta() {
        return this.theta;
    }

    public void setTheta(float theta) {
        this.theta = theta;
    }
}

