/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.ellipse;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.helper.CSSInlineStyle;
import org.wicketstuff.yui.markup.html.ellipse.EllipseHelper;

public abstract class EllipsePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private int itemWidth;
    private int itemHeight;
    private EllipseHelper ellipseHelper;

    public EllipsePanel(String id, IDataProvider provider) {
        super(id);
        this.add(new IBehavior[]{HeaderContributor.forCss(EllipsePanel.class, (String)"EllipsePanel.css")});
        this.ellipseHelper = new EllipseHelper(provider.size());
        Component[] componentArray = new Component[1];
        WebMarkupContainer panel = new WebMarkupContainer("ellipse_panel");
        componentArray[0] = panel;
        this.add(componentArray);
        panel.add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                CSSInlineStyle size = new CSSInlineStyle();
                size.add("width", EllipsePanel.this.getWidth());
                size.add("height", EllipsePanel.this.getHeight());
                return size;
            }
        }, "")});
        panel.add(new Component[]{new DataView("items", provider){

            protected void populateItem(Item item) {
                int index = item.getIndex();
                int left = EllipsePanel.this.ellipseHelper.getLeft(index);
                int top = EllipsePanel.this.ellipseHelper.getTop(index);
                Component child = EllipsePanel.this.newEllipseItem("item", item.getModel(), left, top);
                item.add(new Component[]{child});
                child.add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new Model((Serializable)((Object)("left:" + left + ";top:" + top + ";"))), "")});
                child.add(new IBehavior[]{new AttributeAppender("style", true, (IModel)new Model((Serializable)((Object)EllipsePanel.this.getItemDimention())), "")});
                item.setRenderBodyOnly(true);
            }
        }});
    }

    protected String getItemDimention() {
        CSSInlineStyle dimension = new CSSInlineStyle();
        dimension.add("width", this.getItemWidth());
        dimension.add("height", this.getItemHeight());
        return dimension.toString();
    }

    public abstract Component newEllipseItem(String var1, IModel var2, int var3, int var4);

    public void setDimension(int width, int height, int item_width, int item_height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setItemWidth(item_width);
        this.setItemHeight(item_height);
        this.getEllipseHelper().setWidth(width - item_width);
        this.getEllipseHelper().setHeight(height - item_height);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setItemWidth(int itemWidth) {
        this.itemWidth = itemWidth;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public EllipseHelper getEllipseHelper() {
        return this.ellipseHelper;
    }

    public void setEllipseHelper(EllipseHelper ellipseHelper) {
        this.ellipseHelper = ellipseHelper;
    }
}

