/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.list;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;
import org.wicketstuff.yui.behavior.dragdrop.YuiDDList;
import org.wicketstuff.yui.helper.CollectionsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class YuiDDListView<T>
extends ListView<T> {
    private static final long serialVersionUID = 1L;

    public YuiDDListView(String id, List<T> list) {
        super(id, list);
        this.setOutputMarkupId(true);
    }

    public YuiDDListView(String id, IModel<List<T>> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    protected void populateItem(final ListItem<T> item) {
        item.add(new IBehavior[]{new YuiDDList(this.getGroupId()){
            private static final long serialVersionUID = 1L;

            protected void onDrop(AjaxRequestTarget target, int index, Component dragOverItem) {
                if (dragOverItem == null) {
                    YuiDDListView.this.removeItem(item);
                } else {
                    Object srcItem = item.getModelObject();
                    Object destItem = ((ListItem)dragOverItem).getModelObject();
                    YuiDDListView.this.visitTarget(dragOverItem, index, srcItem);
                    if (!YuiDDListView.this.getList().contains(destItem)) {
                        YuiDDListView.this.removeItem(item);
                    }
                }
            }
        }});
    }

    protected void visitTarget(Component dragOverItem, final int pos, final T item) {
        dragOverItem.visitParents(YuiDDListView.class, (Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                YuiDDListView destList = (YuiDDListView)component;
                destList.onDrop(pos, item);
                return STOP_TRAVERSAL;
            }
        });
    }

    protected String getGroupId() {
        return "DDList_" + this.getMarkupId();
    }

    protected void removeItem(final ListItem<T> item) {
        this.addStateChange(new Change(){
            private static final long serialVersionUID = 1L;
            final int oldIndex;
            final T removedObject;
            {
                this.oldIndex = YuiDDListView.this.getList().indexOf(item.getModelObject());
                this.removedObject = item.getModelObject();
            }

            public void undo() {
                YuiDDListView.this.getList().add(this.oldIndex, this.removedObject);
            }
        });
        item.modelChanging();
        this.getList().remove(item.getModelObject());
        this.modelChanged();
        this.removeAll();
        this.onAjaxUpdate(AjaxRequestTarget.get());
    }

    protected void onDrop(int pos, T destItem) {
        int source = this.getList().indexOf(destItem);
        if (source < 0) {
            this.getList().add(pos, destItem);
        } else {
            CollectionsHelper.rotateInto(this.getList(), source, pos);
        }
        this.onAjaxUpdate(AjaxRequestTarget.get());
    }

    protected abstract void onAjaxUpdate(AjaxRequestTarget var1);
}

