/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.yui.markup.html.menu.AbstractYuiMenu;

public abstract class AbstractYuiMenuItem
extends Panel {
    public static final String MENU_ITEM_LINK_ID = "menuItemLink";
    public static final String MENU_ITEM_LABEL_ID = "menuItemLabel";
    public static final String MENU_ITEM_SUBMENU_ID = "submenu";
    public static final String FRAGMENT_NO_SUBMENU_ID = "menuItemNoSubMenu";
    public static final String FRAGMENT_WITH_SUBMENU_ID = "menuItemWithSubMenu";
    public static final String MENU_ITEM_ID = "theMenuItem";
    private static final String CSS_SELECTED = "selected";
    private static final String CSS_DISABLED = "disabled";
    private static final String CSS_CHECKED = "checked";
    private boolean checked = false;
    private boolean checkedChanged = false;
    private boolean selected = false;
    private boolean disabled = false;
    private String text;
    private WebMarkupContainer menuLink;
    private MarkupContainer subMenu;
    private int index = -1;
    private int groupIndex = -1;
    private YuiMenuPath menuPath;
    private boolean inited = false;

    public AbstractYuiMenuItem(String id, String text) {
        super(id);
        this.setOutputMarkupId(true);
        this.setText(text);
        Label label = this.getLabel(MENU_ITEM_LABEL_ID);
        label.setRenderBodyOnly(true);
        this.add(new IBehavior[]{new CheckedMenuItemBehavior()});
        this.subMenu = this.getSubMenu(MENU_ITEM_SUBMENU_ID);
        if (null == this.subMenu) {
            Fragment fragNoSubMenu = new Fragment(MENU_ITEM_ID, FRAGMENT_NO_SUBMENU_ID);
            this.menuLink = this.getLink(MENU_ITEM_LINK_ID);
            this.menuLink.add(new Component[]{label});
            fragNoSubMenu.add(new Component[]{this.menuLink});
            fragNoSubMenu.setRenderBodyOnly(true);
            this.add(new Component[]{fragNoSubMenu});
        } else {
            Fragment fragWithSubMenu = new Fragment(MENU_ITEM_ID, FRAGMENT_WITH_SUBMENU_ID);
            fragWithSubMenu.add(new Component[]{label});
            this.subMenu.setRenderBodyOnly(true);
            fragWithSubMenu.add(new Component[]{this.subMenu});
            fragWithSubMenu.setRenderBodyOnly(true);
            this.add(new Component[]{fragWithSubMenu});
        }
    }

    protected YuiMenuPath getMenuPath() {
        if (null == this.menuPath) {
            AbstractYuiMenu aym;
            AbstractYuiMenuItem p = (AbstractYuiMenuItem)((Object)this.findParent(AbstractYuiMenuItem.class));
            this.menuPath = p != null ? new YuiMenuPath(this.getIndex(), this.getGroupIndex(), p.getMenuPath(), null) : ((aym = (AbstractYuiMenu)((Object)this.findParent(AbstractYuiMenu.class))) != null ? new YuiMenuPath(this.getIndex(), this.getGroupIndex(), null, aym.getMenuName()) : new YuiMenuPathEmpty(this.getIndex(), this.getGroupIndex()));
        }
        return this.menuPath;
    }

    public abstract WebMarkupContainer getLink(String var1);

    public abstract MarkupContainer getSubMenu(String var1);

    public abstract String getMenuClass();

    public final String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public Label getLabel(String menuItemLabelId) {
        String labelText = this.getText();
        return new Label(menuItemLabelId, labelText);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.setCheckedChanged(true);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected boolean isCheckedChanged() {
        boolean current = this.checkedChanged;
        this.checkedChanged = false;
        return current;
    }

    protected void setCheckedChanged(boolean checkedChanged) {
        this.checkedChanged = checkedChanged;
    }

    public void toggleCheckedScript(AjaxRequestTarget target) {
        String menuPath = this.getMenuPath().toPath();
        if (!menuPath.contains("EMPTY PATH")) {
            String menuItemCheckScript = menuPath + ".cfg.setProperty(\"checked\", " + this.isChecked() + ");";
            target.appendJavascript(menuItemCheckScript);
        }
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    class CheckedMenuItemBehavior
    extends AbstractBehavior {
        CheckedMenuItemBehavior() {
        }

        public void renderHead(IHeaderResponse response) {
            String menuPath;
            if (AbstractYuiMenuItem.this.isCheckedChanged() && !(menuPath = AbstractYuiMenuItem.this.getMenuPath().toPath()).contains("EMPTY PATH")) {
                String menuItemCheckScript = menuPath + ".cfg.setProperty(\"checked\", " + AbstractYuiMenuItem.this.isChecked() + ");";
                response.renderOnLoadJavascript(menuItemCheckScript);
            }
        }
    }

    public static class YuiMenuPathEmpty
    extends YuiMenuPath {
        public YuiMenuPathEmpty(int index, int groupIndex) {
            super(index, groupIndex, null, null);
        }

        public String toPath() {
            return "Index " + this.index + " has EMPTY PATH";
        }
    }

    public static class YuiMenuPath
    implements Serializable {
        protected final int index;
        protected final int groupIndex;
        private final YuiMenuPath parent;
        private final String name;

        public YuiMenuPath(int index, int groupIndex, YuiMenuPath parent, String name) {
            this.index = index;
            this.groupIndex = groupIndex;
            this.parent = parent;
            this.name = name;
        }

        public String toPath() {
            if (this.parent == null && null != this.name) {
                return this.name + ".getItem(" + this.index + ")";
            }
            return this.parent.toPath() + ".cfg.getProperty(\"submenu\").getItem(" + this.index + "," + this.groupIndex + ")";
        }
    }
}

