/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.yui.helper.Attributes;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenu;
import org.wicketstuff.yui.markup.html.menu2.YuiMenuBar;

public abstract class AbstractYuiMenu
extends Panel
implements IYuiMenu {
    private WebMarkupContainer menucontainer;
    private String menuId;
    private static final String MODULE_NAME = "wicket_yui_menu";
    private static final ResourceReference MODULE_JS_REF = new ResourceReference(YuiMenuBar.class, "res/YuiMenu.js");
    private static final String[] MODULE_REQUIRES = new String[]{"menu"};

    public AbstractYuiMenu(String wicketId, String menuId, final boolean addInit) {
        super(wicketId);
        this.menuId = menuId;
        this.add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_JS_REF, MODULE_REQUIRES){

            public String onSuccessJS() {
                StringBuffer buffer = new StringBuffer();
                if (addInit) {
                    buffer.append("var ").append(this.getMenuVar()).append(" = new YAHOO.widget.Menu(").append("\"").append(AbstractYuiMenu.this.getYuiMenuId()).append("\",").append(AbstractYuiMenu.this.getOpts()).append(");");
                    buffer.append(this.getMenuVar()).append(".render();");
                    buffer.append(this.getMenuVar()).append(".show();");
                }
                return buffer.toString();
            }

            private Object getMenuVar() {
                return "var_" + AbstractYuiMenu.this.getYuiMenuId();
            }
        })});
        this.menucontainer = this.getMenuContainer();
        if (this.menucontainer != null) {
            this.add(new Component[]{this.menucontainer});
        }
    }

    public String getYuiMenuId() {
        return this.menuId;
    }

    protected WebMarkupContainer getMenuContainer() {
        if (this.menucontainer == null) {
            this.menucontainer = new WebMarkupContainer("menucontainer"){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (!Strings.isEmpty((CharSequence)AbstractYuiMenu.this.menuId)) {
                        tag.put("id", (CharSequence)AbstractYuiMenu.this.menuId);
                    }
                    tag.put("class", (CharSequence)AbstractYuiMenu.this.getMenuClass());
                }
            };
        }
        return this.menucontainer;
    }

    protected abstract String getMenuClass();

    protected abstract String getMenuName();

    protected String getOpts() {
        Attributes attributes = new Attributes();
        attributes.add(new Attributes("visible", true));
        attributes.add(new Attributes("clicktohide", false));
        return attributes.toString();
    }
}

