/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenu;
import org.wicketstuff.yui.markup.html.menu2.YuiMenu;
import org.wicketstuff.yui.markup.html.menu2.YuiMenuBar;

public abstract class AbstractYuiMenuItem
extends Panel {
    private static final String MODULE_NAME = "wicket_yui_menu_item";
    private static final ResourceReference MODULE_JS_REF = new ResourceReference(YuiMenuBar.class, "res/YuiMenu.js");
    private static final String[] MODULE_REQUIRES = new String[]{"menu"};
    public static final String MENU_ITEM_SUBMENU_ID = "menu";
    private boolean checked = false;
    private boolean checkedChanged = false;
    private boolean selected = false;
    private boolean disabled = false;
    private Component subMenu = null;
    private int index = 0;
    private int groupIndex = 0;
    private static final String ITEM_ID = "item";
    private WebMarkupContainer itemContainer = null;
    private YuiMenuPath menuPath;

    public AbstractYuiMenuItem(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_JS_REF, MODULE_REQUIRES){

            public String onSuccessJS() {
                StringBuffer bufy = new StringBuffer();
                bufy.append("YAHOO.util.Event.onDOMReady(function(){");
                bufy.append("var ").append(this.getMenuItemVar()).append(" = YAHOO.widget.MenuManager.getMenuItem('" + AbstractYuiMenuItem.this.getItemContainer().getMarkupId() + "'); ");
                bufy.append(" if ( " + this.getMenuItemVar() + ") { ");
                bufy.append(this.getMenuItemVar()).append(".cfg.setProperty('disabled', " + AbstractYuiMenuItem.this.isDisabled() + "); ");
                bufy.append(this.getMenuItemVar()).append(".cfg.setProperty('checked', " + AbstractYuiMenuItem.this.isChecked() + ");");
                bufy.append(this.getMenuItemVar()).append(".cfg.setProperty('selected', " + AbstractYuiMenuItem.this.isSelected() + ");");
                bufy.append("}});");
                return bufy.toString();
            }

            private String getMenuItemVar() {
                return "lv";
            }
        })});
    }

    public YuiMenu newSubMenu(String menuId) {
        YuiMenu subMenu = new YuiMenu(menuId, false, false);
        this.setSubMenu((Component)subMenu);
        return subMenu;
    }

    private void setSubMenu(Component newSubMenu) {
        if (this.subMenu != null) {
            this.getItemContainer().remove(this.subMenu);
            this.subMenu = null;
        }
        newSubMenu.setRenderBodyOnly(true);
        this.getItemContainer().add(new Component[]{newSubMenu});
        this.subMenu = newSubMenu;
    }

    protected final WebMarkupContainer getItemContainer() {
        if (this.itemContainer == null) {
            this.itemContainer = new WebMarkupContainer(ITEM_ID);
            this.itemContainer.setOutputMarkupId(true);
            this.add(new Component[]{this.itemContainer});
        }
        return this.itemContainer;
    }

    protected YuiMenuPath getMenuPath() {
        if (null == this.menuPath) {
            IYuiMenu aym;
            AbstractYuiMenuItem p = (AbstractYuiMenuItem)((Object)this.findParent(AbstractYuiMenuItem.class));
            this.menuPath = p != null ? new YuiMenuPath(this.getIndex(), this.getGroupIndex(), p.getMenuPath(), null) : ((aym = (IYuiMenu)this.findParent(IYuiMenu.class)) != null ? new YuiMenuPath(this.getIndex(), this.getGroupIndex(), null, aym.getYuiMenuId()) : new YuiMenuPathEmpty(this.getIndex(), this.getGroupIndex()));
        }
        return this.menuPath;
    }

    public abstract String getMenuClass();

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.setCheckedChanged(true);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected boolean isCheckedChanged() {
        boolean current = this.checkedChanged;
        this.checkedChanged = false;
        return current;
    }

    protected void setCheckedChanged(boolean checkedChanged) {
        this.checkedChanged = checkedChanged;
    }

    public void toggleCheckedScript(AjaxRequestTarget target) {
        String menuPath = this.getMenuPath().toPath();
        if (!menuPath.contains("EMPTY PATH")) {
            String menuItemCheckScript = menuPath + ".cfg.setProperty(\"checked\", " + this.isChecked() + ");";
            target.appendJavascript(menuItemCheckScript + "\nalert(menuItemCheckScript);");
        }
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    class CheckedMenuItemBehavior
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;

        CheckedMenuItemBehavior() {
        }

        public void renderHead(IHeaderResponse response) {
            String menuPath;
            if (AbstractYuiMenuItem.this.isCheckedChanged() && !(menuPath = AbstractYuiMenuItem.this.getMenuPath().toPath()).contains("EMPTY PATH")) {
                String menuItemCheckScript = menuPath + ".cfg.setProperty(\"checked\", " + AbstractYuiMenuItem.this.isChecked() + ");";
                response.renderOnLoadJavascript(menuItemCheckScript);
            }
        }
    }

    public static class YuiMenuPathEmpty
    extends YuiMenuPath {
        private static final long serialVersionUID = 1L;

        public YuiMenuPathEmpty(int index, int groupIndex) {
            super(index, groupIndex, null, null);
        }

        public String toPath() {
            return "Index " + this.index + " has EMPTY PATH";
        }
    }

    public static class YuiMenuPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final int index;
        protected final int groupIndex;
        private final YuiMenuPath parent;
        private final String name;

        public YuiMenuPath(int index, int groupIndex, YuiMenuPath parent, String name) {
            this.index = index;
            this.groupIndex = groupIndex;
            this.parent = parent;
            this.name = name;
        }

        public String toPath() {
            if (this.parent == null && null != this.name) {
                return this.name + ".getItem(" + this.index + ")";
            }
            return this.parent.toPath() + ".cfg.getProperty(\"submenu\").getItem(" + this.index + "," + this.groupIndex + ")";
        }
    }
}

