/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.markup.html.menu2.AbstractYuiMenu;
import org.wicketstuff.yui.markup.html.menu2.AbstractYuiMenuItem;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAction;
import org.wicketstuff.yui.markup.html.menu2.YuiMenuItem;

public class YuiMenu
extends AbstractYuiMenu {
    private static final String MENU_ID = "menu";
    private static final String MENU_ITEMS_ID = "menuItems";
    private List<AbstractYuiMenuItem> items = new ArrayList<AbstractYuiMenuItem>();
    private ListView list;
    private WebMarkupContainer menu = new WebMarkupContainer("menu");
    private boolean firstOfType = false;

    public YuiMenu(String elementId) {
        this(elementId, true, true);
    }

    YuiMenu(String elementId, boolean firstMenu, boolean addInit) {
        super(MENU_ID, elementId, addInit);
        if (firstMenu) {
            this.addFirstOfType();
        }
        Object menuContainer = this.getMenuContainer();
        this.setRenderBodyOnly(true);
        menuContainer = menuContainer == null ? this : menuContainer;
        menuContainer.add(new Component[]{this.menu});
        this.list = new ListView(MENU_ITEMS_ID, this.items){

            protected void populateItem(ListItem item) {
                item.setRenderBodyOnly(true);
                YuiMenuItem mi = (YuiMenuItem)((Object)item.getModelObject());
                mi.setIndex(item.getIndex());
                mi.setRenderBodyOnly(true);
                item.add(new Component[]{mi});
            }
        }.setReuseItems(false);
        this.menu.add(new Component[]{this.list});
    }

    void addFirstOfType() {
        if (!this.firstOfType) {
            this.menu.add(new IBehavior[]{new AttributeAppender("class", true, (IModel)new Model((Serializable)((Object)"first-of-type")), " ")});
            this.firstOfType = true;
        }
    }

    public AbstractYuiMenuItem addMenuItem(String label, AbstractLink link) {
        YuiMenuItem item = new YuiMenuItem(label, link);
        this.addMenuItem(item);
        return item;
    }

    public AbstractYuiMenuItem addMenuItem(IYuiMenuAction action) {
        YuiMenuItem item = new YuiMenuItem(action);
        this.addMenuItem(item);
        return item;
    }

    public void addMenuItem(AbstractYuiMenuItem menuItem) {
        this.items.add(menuItem);
        this.list.setList(this.items);
    }

    public AbstractYuiMenuItem getMenuItem(int idx) {
        ListItem item = (ListItem)this.list.getList().get(idx);
        return item == null ? null : (YuiMenuItem)((Object)item.getModelObject());
    }

    protected String getMenuClass() {
        return "yuimenu";
    }

    public String getMenuName() {
        return "yuiMenu" + this.getYuiMenuId();
    }

    public void removeMenuItem(int idx) {
        AbstractYuiMenuItem item = this.items.get(idx);
        this.items.remove((Object)item);
        this.list.setList(this.items);
    }

    public String getYuiMenuId() {
        return this.getMarkupId();
    }
}

