/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.helper.Attributes;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderModule;
import org.wicketstuff.yui.markup.html.menu2.AbstractYuiMenuItem;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenu;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAction;
import org.wicketstuff.yui.markup.html.menu2.YuiMenuBarItem;

public class YuiMenuBar
extends Panel
implements IYuiMenu {
    private static final long serialVersionUID = 1L;
    public static final String MENU_BAR_ID = "menuBar";
    public static final String MENU_ITEMS_ID = "menuItems";
    private static final String MODULE_NAME = "wicket_yui_menubar";
    private static final ResourceReference MODULE_JS_REF = new ResourceReference(YuiMenuBar.class, "res/YuiMenu.js");
    private static final String[] MODULE_REQUIRES = new String[]{"menu", "animation"};
    private ListView list;
    WebMarkupContainer mg;

    public YuiMenuBar(String wicketId) {
        super(wicketId);
        Component[] componentArray = new Component[1];
        WebMarkupContainer yuiMenuBar = new WebMarkupContainer("skin_container");
        componentArray[0] = yuiMenuBar;
        this.add(componentArray);
        yuiMenuBar.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)this.getCssClass())))});
        yuiMenuBar.setOutputMarkupId(true);
        this.add(new IBehavior[]{YuiLoaderContributor.addModule(new YuiLoaderModule(MODULE_NAME, YuiLoaderModule.ModuleType.js, MODULE_JS_REF, MODULE_REQUIRES){

            public String onSuccessJS() {
                StringBuffer buffer = new StringBuffer();
                buffer.append("var menu = YAHOO.widget.MenuManager.getMenu('" + YuiMenuBar.this.getYuiMenuId() + "');");
                buffer.append("if (menu) { menu.destroy(); } ");
                buffer.append("var ").append(this.getMenuBarVar()).append(" = new YAHOO.widget.MenuBar(").append("\"").append(YuiMenuBar.this.getYuiMenuId()).append("\",").append(YuiMenuBar.this.getOpts()).append(");");
                buffer.append(this.getMenuBarVar()).append(".render();");
                return buffer.toString();
            }

            private Object getMenuBarVar() {
                return "var_" + YuiMenuBar.this.getYuiMenuId();
            }
        })});
        this.mg = new WebMarkupContainer(MENU_BAR_ID);
        this.mg.setOutputMarkupId(true);
        this.mg.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"yuimenubar yuimenubarnav")))});
        yuiMenuBar.add(new Component[]{this.mg});
        this.list = new ListView(MENU_ITEMS_ID, new ArrayList()){

            protected void populateItem(ListItem item) {
                item.setRenderBodyOnly(true);
                YuiMenuBarItem mi = (YuiMenuBarItem)((Object)item.getModelObject());
                if (0 == item.getIndex()) {
                    mi.addFirstOfType();
                }
                mi.setRenderBodyOnly(true);
                item.add(new Component[]{mi});
            }
        }.setReuseItems(true);
        this.mg.add(new Component[]{this.list});
    }

    public YuiMenuBarItem addMenu(String label) {
        YuiMenuBarItem item = new YuiMenuBarItem(label);
        this.addMenuItem(item);
        return item;
    }

    public YuiMenuBarItem addMenu(IYuiMenuAction action) {
        YuiMenuBarItem item = new YuiMenuBarItem(action);
        this.addMenuItem(item);
        return item;
    }

    private void addMenuItem(YuiMenuBarItem menuItem) {
        ArrayList<YuiMenuBarItem> newList = new ArrayList<YuiMenuBarItem>();
        newList.addAll(this.list.getList());
        newList.add(menuItem);
        this.list.setList(newList);
    }

    public AbstractYuiMenuItem getMenuItem(int idx) {
        ListItem item = (ListItem)this.list.getList().get(idx);
        return item == null ? null : (YuiMenuBarItem)((Object)item.getModelObject());
    }

    protected String getOpts() {
        Attributes attributes = new Attributes();
        attributes.add(new Attributes("visible", true));
        attributes.add(new Attributes("clicktohide", false));
        attributes.add(new Attributes("autosubmenudisplay", true));
        attributes.add(new Attributes("hidedelay", 5000));
        attributes.add(new Attributes("lazyload", true));
        return attributes.toString();
    }

    protected String getCssClass() {
        return "yui-skin-sam";
    }

    public String getYuiMenuId() {
        return this.mg.getMarkupId();
    }
}

