/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.menu2;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.yui.markup.html.menu2.AbstractYuiMenuItem;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAction;
import org.wicketstuff.yui.markup.html.menu2.IYuiMenuAjaxAction;

public class YuiMenuBarItem
extends AbstractYuiMenuItem {
    private static final long serialVersionUID = 1L;
    private static final String MENU_ITEM_ID = "menu";
    private static final String LINK_ID = "link";
    private static final String LINK_LABEL_ID = "linkLabel";
    private boolean firstOfType = false;

    YuiMenuBarItem(String label) {
        this(label, null);
    }

    YuiMenuBarItem(final IYuiMenuAction action) {
        super(MENU_ITEM_ID);
        Object link = null;
        if (action instanceof AbstractLink) {
            link = (AbstractLink)action;
            if (!link.getId().equals(LINK_ID)) {
                throw new RuntimeException("Link's id needs to be 'link' ");
            }
        } else {
            link = action instanceof IYuiMenuAjaxAction ? new AjaxFallbackLink<String>(LINK_ID, action.getName()){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (action instanceof IYuiMenuAjaxAction && target != null) {
                        ((IYuiMenuAjaxAction)action).onClick(target, YuiMenuBarItem.LINK_ID);
                    } else {
                        action.onClick();
                    }
                }
            } : new Link<String>(LINK_ID, action.getName()){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    action.onClick();
                }
            };
        }
        this.getItemContainer().add(new Component[]{link});
        link.add(new Component[]{new Label(LINK_LABEL_ID, action.getName()).setRenderBodyOnly(true)});
        this.newSubMenu("emptyMenu").setVisible(false);
    }

    YuiMenuBarItem(String label, AbstractLink link) {
        super(MENU_ITEM_ID);
        AbstractLink l = link;
        if (l == null) {
            l = new WebMarkupContainer(LINK_ID);
        }
        if (!l.getId().equals(LINK_ID)) {
            throw new RuntimeException("Link's id needs to be 'link' ");
        }
        this.getItemContainer().add(new Component[]{l});
        l.add(new Component[]{new Label(LINK_LABEL_ID, (IModel)new Model((Serializable)((Object)label))).setRenderBodyOnly(true)});
        this.newSubMenu("emptyMenu").setVisible(false);
    }

    public String getMenuClass() {
        return "yuimenuitem";
    }

    void addFirstOfType() {
        if (!this.firstOfType) {
            this.getItemContainer().add(new IBehavior[]{new AttributeAppender("class", true, (IModel)new Model((Serializable)((Object)"first-of-type")), " ")});
            this.firstOfType = true;
        }
    }
}

